/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.api.MutableUriInfo;
import org.apache.fineract.portfolio.loanaccount.api.LoanTransactionsApiResource;
import org.springframework.stereotype.Component;

@Component
public class GetLoanTransactionByIdCommandStrategy
implements CommandStrategy {
    private final LoanTransactionsApiResource loanTransactionsApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        MutableUriInfo parameterizedUriInfo = new MutableUriInfo(uriInfo);
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        Long loanId = Long.parseLong((String)pathParameters.get(1));
        Long transactionId = relativeUrl.indexOf(63) > 0 ? Long.valueOf(Long.parseLong(StringUtils.substringBeforeLast((String)((String)pathParameters.get(3)), (String)"?"))) : Long.valueOf(Long.parseLong((String)pathParameters.get(3)));
        Map queryParameters = new HashMap();
        if (relativeUrl.indexOf(63) > 0) {
            queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
            CommandStrategyUtils.addQueryParametersToUriInfo((MutableUriInfo)parameterizedUriInfo, queryParameters);
        }
        String fields = null;
        if (!queryParameters.isEmpty() && queryParameters.containsKey("fields")) {
            fields = (String)queryParameters.get("fields");
        }
        String responseBody = this.loanTransactionsApiResource.retrieveTransaction(loanId, transactionId, fields, uriInfo);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public GetLoanTransactionByIdCommandStrategy(LoanTransactionsApiResource loanTransactionsApiResource) {
        this.loanTransactionsApiResource = loanTransactionsApiResource;
    }
}

