/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.savings.data;

import com.google.gson.JsonElement;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.UnsupportedParameterException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SelfSavingsDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> allowedAssociationParameters = new HashSet<String>(Arrays.asList("transactions", "charges"));

    @Autowired
    public SelfSavingsDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateRetrieveSavings(UriInfo uriInfo) {
        ArrayList<String> unsupportedParams = new ArrayList<String>();
        this.validateTemplate(uriInfo, unsupportedParams);
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            associationParameters.removeAll(allowedAssociationParameters);
            if (!associationParameters.isEmpty()) {
                unsupportedParams.addAll(associationParameters);
            }
        }
        if (uriInfo.getQueryParameters().getFirst((Object)"exclude") != null) {
            unsupportedParams.add("exclude");
        }
        this.throwExceptionIfReqd(unsupportedParams);
    }

    public void validateRetrieveSavingsTransaction(UriInfo uriInfo) {
        ArrayList unsupportedParams = new ArrayList();
        this.validateTemplate(uriInfo, unsupportedParams);
        this.throwExceptionIfReqd(unsupportedParams);
    }

    private void throwExceptionIfReqd(List<String> unsupportedParams) {
        if (unsupportedParams.size() > 0) {
            throw new UnsupportedParameterException(unsupportedParams);
        }
    }

    private void validateTemplate(UriInfo uriInfo, List<String> unsupportedParams) {
        boolean templateRequest = ApiParameterHelper.template((MultivaluedMap)uriInfo.getQueryParameters());
        if (templateRequest) {
            unsupportedParams.add("template");
        }
    }

    public HashMap<String, Object> validateSavingsApplication(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savings");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().longGreaterThanZero();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("clientId", clientId);
        return parameterMap;
    }
}

