/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.springbatch.PropertyService;
import org.springframework.stereotype.Service;

@Service
public class PropertyServiceImpl
implements PropertyService {
    private final FineractProperties fineractProperties;

    public Integer getPartitionSize(String jobName) {
        return this.getProperty(jobName, FineractProperties.PartitionedJobProperty::getPartitionSize);
    }

    public Integer getChunkSize(String jobName) {
        return this.getProperty(jobName, FineractProperties.PartitionedJobProperty::getChunkSize);
    }

    public Integer getRetryLimit(String jobName) {
        return this.getProperty(jobName, FineractProperties.PartitionedJobProperty::getRetryLimit);
    }

    public Integer getThreadPoolCorePoolSize(String jobName) {
        return this.getProperty(jobName, FineractProperties.PartitionedJobProperty::getThreadPoolCorePoolSize);
    }

    public Integer getThreadPoolMaxPoolSize(String jobName) {
        return this.getProperty(jobName, FineractProperties.PartitionedJobProperty::getThreadPoolMaxPoolSize);
    }

    public Integer getThreadPoolQueueCapacity(String jobName) {
        return this.getProperty(jobName, FineractProperties.PartitionedJobProperty::getThreadPoolQueueCapacity);
    }

    public Integer getPollInterval(String jobName) {
        return this.getProperty(jobName, FineractProperties.PartitionedJobProperty::getPollInterval);
    }

    private Integer getProperty(String jobName, Function<? super FineractProperties.PartitionedJobProperty, Integer> function) {
        List jobProperties = this.fineractProperties.getPartitionedJob().getPartitionedJobProperties();
        return jobProperties.stream().filter(jobProperty -> jobName.equals(jobProperty.getJobName())).findFirst().map(function).orElse(1);
    }

    @Generated
    public PropertyServiceImpl(FineractProperties fineractProperties) {
        this.fineractProperties = fineractProperties;
    }
}

