/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor.registry;

import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.DefaultLocker;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.EmptyRegistryAdaptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.InterceptorRegistryAdaptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.Locker;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class InterceptorRegistry {
    private static final Locker LOCK = new DefaultLocker();
    private static final AtomicReference<InterceptorRegistryAdaptor> REGISTRY = new AtomicReference<InterceptorRegistryAdaptor>(EmptyRegistryAdaptor.EMPTY);
    private static boolean interceptorHolderEnable = true;

    public static void bind(InterceptorRegistryAdaptor interceptorRegistryAdaptor, Object lock) {
        Objects.requireNonNull(interceptorRegistryAdaptor, "interceptorRegistryAdaptor");
        if (!LOCK.lock(lock)) {
            throw new IllegalStateException("bind failed. lock=" + lock + " current=" + LOCK.getLock());
        }
        REGISTRY.set(interceptorRegistryAdaptor);
    }

    public static void unbind(Object lock) {
        if (!LOCK.unlock(lock)) {
            throw new IllegalStateException("unbind failed. lock=" + lock + " current=" + LOCK.getLock());
        }
        REGISTRY.set(EmptyRegistryAdaptor.EMPTY);
    }

    public static Interceptor getInterceptor(int key) {
        return REGISTRY.get().getInterceptor(key);
    }

    public static boolean contains(int key) {
        return REGISTRY.get().contains(key);
    }

    public static void setInterceptorHolderEnable(boolean enable) {
        interceptorHolderEnable = enable;
    }

    public static boolean isInterceptorHolderEnable() {
        return interceptorHolderEnable;
    }
}

