/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.interceptor.ApiIdAwareAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor0;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor1;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor2;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor3;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor4;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor5;
import com.navercorp.pinpoint.bootstrap.interceptor.StaticAroundInterceptor;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.StdoutCommonLoggerFactory;
import java.util.Arrays;

public class LoggingInterceptor
implements StaticAroundInterceptor,
AroundInterceptor,
AroundInterceptor0,
AroundInterceptor1,
AroundInterceptor2,
AroundInterceptor3,
AroundInterceptor4,
AroundInterceptor5,
ApiIdAwareAroundInterceptor {
    private final CommonLogger logger;

    public LoggingInterceptor(String loggerName) {
        this.logger = StdoutCommonLoggerFactory.INSTANCE.getLogger(loggerName);
    }

    @Override
    public void before(Object target, String className, String methodName, String parameterDescription, Object[] args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("before " + LoggingInterceptor.defaultString(target) + " " + className + "." + methodName + parameterDescription + " args:" + Arrays.toString(args));
        }
    }

    @Override
    public void after(Object target, String className, String methodName, String parameterDescription, Object[] args, Object result, Throwable throwable) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("after " + LoggingInterceptor.defaultString(target) + " " + className + "." + methodName + parameterDescription + " args:" + Arrays.toString(args) + " result:" + result + " Throwable:" + throwable);
        }
    }

    @Override
    public void before(Object target, Object[] args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("before " + LoggingInterceptor.defaultString(target) + " args:" + Arrays.toString(args));
        }
    }

    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("after " + LoggingInterceptor.defaultString(target) + " args:" + Arrays.toString(args) + " result:" + result + " Throwable:" + throwable);
        }
    }

    public static String defaultString(Object object) {
        return String.valueOf(object);
    }

    @Override
    public void before(Object target, int apiId, Object[] args) {
    }

    @Override
    public void after(Object target, int apiId, Object[] args, Object result, Throwable throwable) {
    }

    @Override
    public void before(Object target) {
    }

    @Override
    public void after(Object target, Object result, Throwable throwable) {
    }

    @Override
    public void before(Object target, Object arg0) {
    }

    @Override
    public void after(Object target, Object arg0, Object result, Throwable throwable) {
    }

    @Override
    public void before(Object target, Object arg0, Object arg1) {
    }

    @Override
    public void after(Object target, Object arg0, Object arg1, Object result, Throwable throwable) {
    }

    @Override
    public void before(Object target, Object arg0, Object arg1, Object arg2) {
    }

    @Override
    public void after(Object target, Object arg0, Object arg1, Object arg2, Object result, Throwable throwable) {
    }

    @Override
    public void before(Object target, Object arg0, Object arg1, Object arg2, Object arg3) {
    }

    @Override
    public void after(Object target, Object arg0, Object arg1, Object arg2, Object arg3, Object result, Throwable throwable) {
    }

    @Override
    public void before(Object target, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
    }

    @Override
    public void after(Object target, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object result, Throwable throwable) {
    }
}

