/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.concurrent.executor;

import com.navercorp.pinpoint.common.profiler.concurrent.executor.MultiConsumer;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SingleConsumer<T>
implements MultiConsumer<T> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Consumer<T> consumer;

    public SingleConsumer(Consumer<T> consumer) {
        this.consumer = Objects.requireNonNull(consumer, "consumer");
    }

    @Override
    public void acceptN(Collection<T> messageList) {
        Object[] dataList = messageList.toArray();
        int size = messageList.size();
        for (int i = 0; i < size; ++i) {
            try {
                this.accept(dataList[i]);
                continue;
            }
            catch (Throwable th) {
                this.logger.warn("Unexpected Error. Cause:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    @Override
    public void accept(T message) {
        this.consumer.accept(message);
    }
}

