/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;

public final class UriUtils {
    private static final String SPLIT = "&";
    private static final String EQUAL = "=";
    private static final String DEFAULT_ENCODING = "ISO_8859_1";

    private UriUtils() {
    }

    public static Map<String, String> parseQuery(String uriString) {
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return UriUtils.parseQuery(uri);
    }

    public static Map<String, String> parseQuery(String uriString, String encoding) {
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return UriUtils.parseQuery(uri, encoding);
    }

    public static Map<String, String> parseQuery(URI uri) {
        return UriUtils.parseQuery(uri, DEFAULT_ENCODING);
    }

    public static Map<String, String> parseQuery(URI uri, String encoding) {
        if (uri == null || StringUtils.isBlank((String)uri.getQuery())) {
            return Collections.EMPTY_MAP;
        }
        String query = uri.getRawQuery();
        HashMap<String, String> params = new HashMap<String, String>();
        Scanner scan = new Scanner(query);
        scan.useDelimiter(SPLIT);
        while (scan.hasNext()) {
            String token = scan.next().trim();
            String[] pair = token.split(EQUAL);
            String key = UriUtils.decode(pair[0], encoding);
            String value = null;
            if (pair.length == 2) {
                value = UriUtils.decode(pair[1], encoding);
            }
            params.put(key, value);
        }
        return params;
    }

    private static String decode(String content, String encoding) {
        try {
            return URLDecoder.decode(content, encoding != null ? encoding : DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

