/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.ddl;

import com.alibaba.otter.canal.filter.PatternUtils;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.DdlResult;
import com.alibaba.otter.canal.protocol.CanalEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.regex.Perl5Matcher;

public class SimpleDdlParser {
    public static final String CREATE_PATTERN = "^\\s*CREATE\\s*(TEMPORARY)?\\s*TABLE\\s*(.*)$";
    public static final String DROP_PATTERN = "^\\s*DROP\\s*(TEMPORARY)?\\s*TABLE\\s*(.*)$";
    public static final String ALERT_PATTERN = "^\\s*ALTER\\s*(IGNORE)?\\s*TABLE\\s*(.*)$";
    public static final String TRUNCATE_PATTERN = "^\\s*TRUNCATE\\s*(TABLE)?\\s*(.*)$";
    public static final String TABLE_PATTERN = "^(IF\\s*NOT\\s*EXISTS\\s*)?(IF\\s*EXISTS\\s*)?(`?.+?`?[;\\(\\s]+?)?.*$";
    public static final String INSERT_PATTERN = "^\\s*(INSERT|MERGE|REPLACE)(.*)$";
    public static final String UPDATE_PATTERN = "^\\s*UPDATE(.*)$";
    public static final String DELETE_PATTERN = "^\\s*DELETE(.*)$";
    public static final String RENAME_PATTERN = "^\\s*RENAME\\s+TABLE\\s+(.+?)\\s+TO\\s+(.+?)$";
    public static final String RENAME_REMNANT_PATTERN = "^\\s*(.+?)\\s+TO\\s+(.+?)$";
    public static final String CREATE_INDEX_PATTERN = "^\\s*CREATE\\s*(UNIQUE)?(FULLTEXT)?(SPATIAL)?\\s*INDEX\\s*(.*?)\\s+ON\\s+(.*?)$";
    public static final String DROP_INDEX_PATTERN = "^\\s*DROP\\s*INDEX\\s*(.*?)\\s+ON\\s+(.*?)$";

    public static DdlResult parse(String queryString, String schmeaName) {
        DdlResult result = SimpleDdlParser.parseDdl(queryString = SimpleDdlParser.removeComment(queryString), schmeaName, ALERT_PATTERN, 2);
        if (result != null) {
            result.setType(CanalEntry.EventType.ALTER);
            return result;
        }
        result = SimpleDdlParser.parseDdl(queryString, schmeaName, CREATE_PATTERN, 2);
        if (result != null) {
            result.setType(CanalEntry.EventType.CREATE);
            return result;
        }
        result = SimpleDdlParser.parseDdl(queryString, schmeaName, DROP_PATTERN, 2);
        if (result != null) {
            result.setType(CanalEntry.EventType.ERASE);
            return result;
        }
        result = SimpleDdlParser.parseDdl(queryString, schmeaName, TRUNCATE_PATTERN, 2);
        if (result != null) {
            result.setType(CanalEntry.EventType.TRUNCATE);
            return result;
        }
        result = SimpleDdlParser.parseRename(queryString, schmeaName, RENAME_PATTERN);
        if (result != null) {
            result.setType(CanalEntry.EventType.RENAME);
            String[] renameStrings = queryString.split(",");
            if (renameStrings.length > 1) {
                DdlResult lastResult = result;
                for (int i = 1; i < renameStrings.length; ++i) {
                    DdlResult ddlResult = SimpleDdlParser.parseRename(renameStrings[i], schmeaName, RENAME_REMNANT_PATTERN);
                    ddlResult.setType(CanalEntry.EventType.RENAME);
                    lastResult.setRenameTableResult(ddlResult);
                    lastResult = ddlResult;
                }
            }
            return result;
        }
        result = SimpleDdlParser.parseDdl(queryString, schmeaName, CREATE_INDEX_PATTERN, 5);
        if (result != null) {
            result.setType(CanalEntry.EventType.CINDEX);
            return result;
        }
        result = SimpleDdlParser.parseDdl(queryString, schmeaName, DROP_INDEX_PATTERN, 2);
        if (result != null) {
            result.setType(CanalEntry.EventType.DINDEX);
            return result;
        }
        result = new DdlResult(schmeaName);
        if (SimpleDdlParser.isDml(queryString, INSERT_PATTERN)) {
            result.setType(CanalEntry.EventType.INSERT);
            return result;
        }
        if (SimpleDdlParser.isDml(queryString, UPDATE_PATTERN)) {
            result.setType(CanalEntry.EventType.UPDATE);
            return result;
        }
        if (SimpleDdlParser.isDml(queryString, DELETE_PATTERN)) {
            result.setType(CanalEntry.EventType.DELETE);
            return result;
        }
        result.setType(CanalEntry.EventType.QUERY);
        return result;
    }

    private static DdlResult parseDdl(String queryString, String schmeaName, String pattern, int index) {
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.matches(queryString, PatternUtils.getPattern((String)pattern))) {
            DdlResult result = SimpleDdlParser.parseTableName(matcher.getMatch().group(index), schmeaName);
            return result != null ? result : new DdlResult(schmeaName);
        }
        return null;
    }

    private static boolean isDml(String queryString, String pattern) {
        Perl5Matcher matcher = new Perl5Matcher();
        return matcher.matches(queryString, PatternUtils.getPattern((String)pattern));
    }

    private static DdlResult parseRename(String queryString, String schmeaName, String pattern) {
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.matches(queryString, PatternUtils.getPattern((String)pattern))) {
            DdlResult orign = SimpleDdlParser.parseTableName(matcher.getMatch().group(1), schmeaName);
            DdlResult target = SimpleDdlParser.parseTableName(matcher.getMatch().group(2), schmeaName);
            if (orign != null && target != null) {
                return new DdlResult(target.getSchemaName(), target.getTableName(), orign.getSchemaName(), orign.getTableName());
            }
        }
        return null;
    }

    private static DdlResult parseTableName(String matchString, String schmeaName) {
        Perl5Matcher tableMatcher = new Perl5Matcher();
        if (tableMatcher.matches(matchString = matchString + " ", PatternUtils.getPattern((String)TABLE_PATTERN))) {
            String tableString = tableMatcher.getMatch().group(3);
            if (StringUtils.isEmpty((String)tableString)) {
                return null;
            }
            tableString = StringUtils.removeEnd((String)tableString, (String)";");
            tableString = StringUtils.removeEnd((String)tableString, (String)"(");
            tableString = StringUtils.trim((String)tableString);
            String[] names = StringUtils.split((String)(tableString = SimpleDdlParser.removeEscape(tableString)), (String)".");
            if (names.length == 0) {
                return null;
            }
            if (names != null && names.length > 1) {
                return new DdlResult(SimpleDdlParser.removeEscape(names[0]), SimpleDdlParser.removeEscape(names[1]));
            }
            return new DdlResult(schmeaName, SimpleDdlParser.removeEscape(names[0]));
        }
        return null;
    }

    private static String removeEscape(String str) {
        String result = StringUtils.removeEnd((String)str, (String)"`");
        result = StringUtils.removeStart((String)result, (String)"`");
        return result;
    }

    private static String removeComment(String sql) {
        if (sql == null) {
            return null;
        }
        String start = "/*";
        String end = "*/";
        int index0;
        while ((index0 = sql.indexOf(start)) != -1) {
            int index1 = sql.indexOf(end, index0);
            if (index1 == -1) {
                return sql;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(sql.substring(0, index0));
            sb.append(" ");
            sb.append(sql.substring(index1 + end.length()));
            sql = sb.toString();
        }
        return sql;
    }
}

