/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul;

import com.ecwid.consul.UrlParameters;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Utils {
    public static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("So strange - every JVM has to support UTF-8 encoding.");
        }
    }

    public static String encodeUrl(String str) {
        try {
            URL url = new URL(str);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            return uri.toASCIIString();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't encode url", e);
        }
    }

    public static String generateUrl(String baseUrl, UrlParameters ... params) {
        return Utils.generateUrl(baseUrl, Arrays.asList(params));
    }

    public static String generateUrl(String baseUrl, List<UrlParameters> params) {
        if (params == null) {
            return baseUrl;
        }
        ArrayList<String> allParams = new ArrayList<String>();
        for (UrlParameters item : params) {
            if (item == null) continue;
            allParams.addAll(item.toUrlParameters());
        }
        StringBuilder result = new StringBuilder(baseUrl);
        Iterator paramsIterator = allParams.iterator();
        if (paramsIterator.hasNext()) {
            result.append("?").append((String)paramsIterator.next());
            while (paramsIterator.hasNext()) {
                result.append("&").append((String)paramsIterator.next());
            }
        }
        return result.toString();
    }

    public static Map<String, String> createTokenMap(String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Consul-Token", token);
        return headers;
    }

    public static String toSecondsString(long waitTime) {
        return String.valueOf(waitTime) + "s";
    }

    public static String assembleAgentAddress(String host, int port, String path) {
        String agentPath = "";
        if (path != null && !path.trim().isEmpty()) {
            agentPath = "/" + path;
        }
        return String.format("%s:%d%s", host, port, agentPath);
    }
}

