/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.logger.adapter.log4j2;

import com.alibaba.nacos.common.logging.NacosLoggingAdapter;
import com.alibaba.nacos.common.logging.NacosLoggingProperties;
import com.alibaba.nacos.common.utils.ResourceUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.logger.adapter.log4j2.Log4j2NacosLoggingPropertiesHolder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4J2NacosLoggingAdapter
implements NacosLoggingAdapter {
    private static final String NACOS_LOG4J2_LOCATION = "classpath:nacos-log4j2.xml";
    private static final String FILE_PROTOCOL = "file";
    private static final String NACOS_LOGGER_PREFIX = "com.alibaba.nacos";
    private static final String NACOS_LOG4J2_PLUGIN_PACKAGE = "com.alibaba.nacos.client.logging.log4j2";
    private static final String APPENDER_MARK = "ASYNC_NAMING";
    private static final String LOG4J2_CLASSES = "org.apache.logging.slf4j.Log4jLogger";

    public boolean isAdaptedLogger(Class<?> loggerClass) {
        Class<?> expectedLoggerClass = this.getExpectedLoggerClass();
        return null != expectedLoggerClass && expectedLoggerClass.isAssignableFrom(loggerClass);
    }

    private Class<?> getExpectedLoggerClass() {
        try {
            return Class.forName(LOG4J2_CLASSES);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public boolean isNeedReloadConfiguration() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration contextConfiguration = loggerContext.getConfiguration();
        for (Map.Entry entry : contextConfiguration.getAppenders().entrySet()) {
            if (!APPENDER_MARK.equals(((Appender)entry.getValue()).getName())) continue;
            return false;
        }
        return true;
    }

    public String getDefaultConfigLocation() {
        return NACOS_LOG4J2_LOCATION;
    }

    public void loadConfiguration(NacosLoggingProperties loggingProperties) {
        Log4j2NacosLoggingPropertiesHolder.setProperties(loggingProperties);
        String location = loggingProperties.getLocation();
        this.loadConfiguration(location);
    }

    private void loadConfiguration(String location) {
        if (StringUtils.isBlank((CharSequence)location)) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration contextConfiguration = loggerContext.getConfiguration();
        Configuration configuration = this.loadConfiguration(loggerContext, location);
        configuration.getPluginPackages().add(NACOS_LOG4J2_PLUGIN_PACKAGE);
        configuration.start();
        Map appenders = configuration.getAppenders();
        for (Appender appender : appenders.values()) {
            contextConfiguration.addAppender(appender);
        }
        Map loggers = configuration.getLoggers();
        for (String name : loggers.keySet()) {
            if (!name.startsWith(NACOS_LOGGER_PREFIX)) continue;
            contextConfiguration.addLogger(name, (LoggerConfig)loggers.get(name));
        }
        loggerContext.updateLoggers();
    }

    private Configuration loadConfiguration(LoggerContext loggerContext, String location) {
        try {
            URL url = ResourceUtils.getResourceUrl((String)location);
            ConfigurationSource source = this.getConfigurationSource(url);
            return ConfigurationFactory.getInstance().getConfiguration(loggerContext, source);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize Log4J2 logging from " + location, e);
        }
    }

    private ConfigurationSource getConfigurationSource(URL url) throws IOException {
        InputStream stream = url.openStream();
        if (FILE_PROTOCOL.equals(url.getProtocol())) {
            return new ConfigurationSource(stream, ResourceUtils.getResourceAsFile((URL)url));
        }
        return new ConfigurationSource(stream, url);
    }
}

