/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.source.protocol;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.config.connector.http.SourceConnectorConfig;
import org.apache.eventmesh.connector.http.source.protocol.Protocol;
import org.apache.eventmesh.connector.http.source.protocol.impl.CloudEventProtocol;
import org.apache.eventmesh.connector.http.source.protocol.impl.CommonProtocol;
import org.apache.eventmesh.connector.http.source.protocol.impl.GitHubProtocol;

public class ProtocolFactory {
    private static final ConcurrentHashMap<String, Class<?>> protocols = new ConcurrentHashMap();

    public static void registerProtocol(String name, Class<?> clazz) {
        if (!Protocol.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " does not implement Protocol interface");
        }
        protocols.put(name.toLowerCase(), clazz);
    }

    public static Protocol getInstance(SourceConnectorConfig sourceConnectorConfig, String name) {
        Class<?> clazz = Optional.ofNullable(protocols.get(name.toLowerCase())).orElseThrow(() -> new IllegalArgumentException("Protocol " + name + " is not registered"));
        try {
            Protocol protocol = (Protocol)clazz.newInstance();
            protocol.initialize(sourceConnectorConfig);
            return protocol;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Failed to instantiate protocol " + name, e);
        }
    }

    static {
        ProtocolFactory.registerProtocol("CloudEvent", CloudEventProtocol.class);
        ProtocolFactory.registerProtocol("GitHub", GitHubProtocol.class);
        ProtocolFactory.registerProtocol("Common", CommonProtocol.class);
    }
}

