/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.instrument.ASMBytecodeDumpService;
import com.navercorp.pinpoint.profiler.instrument.BytecodeDumpService;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Objects;

public class BytecodeDumpTransformer
implements ClassFileTransformer {
    private final ClassFileTransformer delegate;
    private final BytecodeDumpService bytecodeDumpService;

    public static ClassFileTransformer wrap(ClassFileTransformer classFileTransformer, ProfilerConfig profilerConfig) {
        return new BytecodeDumpTransformer(classFileTransformer, profilerConfig);
    }

    private BytecodeDumpTransformer(ClassFileTransformer delegate, ProfilerConfig profilerConfig) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.bytecodeDumpService = new ASMBytecodeDumpService(profilerConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] transformBytes = null;
        boolean success = false;
        try {
            transformBytes = this.delegate.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            success = true;
            byte[] byArray = transformBytes;
            return byArray;
        }
        finally {
            this.bytecodeDumpService.dumpBytecode("original bytecode dump", className, classfileBuffer, loader);
            boolean bytecodeChanged = this.isChanged(classfileBuffer, transformBytes);
            if (success && bytecodeChanged) {
                this.bytecodeDumpService.dumpBytecode("transform bytecode dump", className, transformBytes, loader);
            }
        }
    }

    private boolean isChanged(byte[] classfileBuffer, byte[] transformBytes) {
        if (transformBytes == null) {
            return false;
        }
        return classfileBuffer != transformBytes;
    }
}

