/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.grpc.trace.PAgentUriStat;
import com.navercorp.pinpoint.grpc.trace.PEachUriStat;
import com.navercorp.pinpoint.grpc.trace.PUriHistogram;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.UriStatMapper;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.AgentUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.EachUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.URIKey;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatHistogram;
import java.util.Map;

public class UriStatMapperImpl
implements UriStatMapper {
    @Override
    public PAgentUriStat map(AgentUriStatData agentUriStatData) {
        if (agentUriStatData == null) {
            return null;
        }
        PAgentUriStat.Builder pAgentUriStat = PAgentUriStat.newBuilder();
        if (agentUriStatData != null) {
            pAgentUriStat.setBucketVersion(this.getBucketVersion(agentUriStatData));
        }
        if (agentUriStatData.getAllUriStatData() != null) {
            for (Map.Entry<URIKey, EachUriStatData> allUriStatDatum : agentUriStatData.getAllUriStatData()) {
                pAgentUriStat.addEachUriStat(this.map(allUriStatDatum));
            }
        }
        return pAgentUriStat.build();
    }

    @Override
    public PEachUriStat map(Map.Entry<URIKey, EachUriStatData> eachUriStatDataEntry) {
        UriStatHistogram failedHistogram;
        UriStatHistogram totalHistogram;
        if (eachUriStatDataEntry == null) {
            return null;
        }
        PEachUriStat.Builder pEachUriStat = PEachUriStat.newBuilder();
        String uri = this.eachUriStatDataEntryValueUri(eachUriStatDataEntry);
        if (uri != null) {
            pEachUriStat.setUri(uri);
        }
        if ((totalHistogram = this.eachUriStatDataEntryValueTotalHistogram(eachUriStatDataEntry)) != null) {
            pEachUriStat.setTotalHistogram(this.checkEmptyThenMap(totalHistogram));
        }
        if ((failedHistogram = this.eachUriStatDataEntryValueFailedHistogram(eachUriStatDataEntry)) != null) {
            pEachUriStat.setFailedHistogram(this.checkEmptyThenMap(failedHistogram));
        }
        pEachUriStat.setTimestamp(this.eachUriStatDataEntryKeyTimestamp(eachUriStatDataEntry));
        return pEachUriStat.build();
    }

    @Override
    public PUriHistogram map(UriStatHistogram uriStatHistogram) {
        if (uriStatHistogram == null) {
            return null;
        }
        PUriHistogram.Builder pUriHistogram = PUriHistogram.newBuilder();
        pUriHistogram.setTotal(uriStatHistogram.getTotal());
        pUriHistogram.setMax(uriStatHistogram.getMax());
        this.map(uriStatHistogram, pUriHistogram);
        return pUriHistogram.build();
    }

    private String eachUriStatDataEntryValueUri(Map.Entry<URIKey, EachUriStatData> entry) {
        if (entry == null) {
            return null;
        }
        EachUriStatData value = entry.getValue();
        if (value == null) {
            return null;
        }
        String uri = value.getUri();
        if (uri == null) {
            return null;
        }
        return uri;
    }

    private UriStatHistogram eachUriStatDataEntryValueTotalHistogram(Map.Entry<URIKey, EachUriStatData> entry) {
        if (entry == null) {
            return null;
        }
        EachUriStatData value = entry.getValue();
        if (value == null) {
            return null;
        }
        UriStatHistogram totalHistogram = value.getTotalHistogram();
        if (totalHistogram == null) {
            return null;
        }
        return totalHistogram;
    }

    private UriStatHistogram eachUriStatDataEntryValueFailedHistogram(Map.Entry<URIKey, EachUriStatData> entry) {
        if (entry == null) {
            return null;
        }
        EachUriStatData value = entry.getValue();
        if (value == null) {
            return null;
        }
        UriStatHistogram failedHistogram = value.getFailedHistogram();
        if (failedHistogram == null) {
            return null;
        }
        return failedHistogram;
    }

    private long eachUriStatDataEntryKeyTimestamp(Map.Entry<URIKey, EachUriStatData> entry) {
        if (entry == null) {
            return 0L;
        }
        URIKey key = entry.getKey();
        if (key == null) {
            return 0L;
        }
        long timestamp = key.getTimestamp();
        return timestamp;
    }
}

