/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.druid.common.exception.ErrorResponseTransformStrategy;
import org.apache.druid.common.exception.NoErrorResponseTransformStrategy;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.HumanReadableBytesRange;
import org.apache.druid.utils.JvmUtils;
import org.eclipse.jetty.http.UriCompliance;
import org.joda.time.Period;

public class ServerConfig {
    public static final int DEFAULT_GZIP_INFLATE_BUFFER_SIZE = 4096;
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int numThreads = ServerConfig.getDefaultNumThreads();
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int queueSize = Integer.MAX_VALUE;
    @JsonProperty
    private boolean enableRequestLimit = false;
    @JsonProperty
    @NotNull
    private Period maxIdleTime = new Period((Object)"PT5m");
    @JsonProperty
    @Min(value=0L)
    private @Min(value=0L) long defaultQueryTimeout = TimeUnit.MINUTES.toMillis(5L);
    @JsonProperty
    @NotNull
    @HumanReadableBytesRange(min=1L)
    private HumanReadableBytes maxScatterGatherBytes = HumanReadableBytes.valueOf((long)Long.MAX_VALUE);
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int maxSubqueryRows = 100000;
    @JsonProperty
    private String maxSubqueryBytes = "disabled";
    @JsonProperty
    private boolean useNestedForUnknownTypeInSubquery = false;
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) long maxQueryTimeout = Long.MAX_VALUE;
    @JsonProperty
    private int maxRequestHeaderSize = 8192;
    @JsonProperty
    @NotNull
    private Period gracefulShutdownTimeout = Period.ZERO;
    @JsonProperty
    @NotNull
    private Period unannouncePropagationDelay = Period.ZERO;
    @JsonProperty
    @Min(value=0L)
    private @Min(value=0L) int inflateBufferSize = 4096;
    @JsonProperty
    @Min(value=-1L)
    @Max(value=9L)
    private @Min(value=-1L) @Max(value=9L) int compressionLevel = -1;
    @JsonProperty
    private boolean enableForwardedRequestCustomizer = false;
    @JsonProperty
    @NotNull
    private List<String> allowedHttpMethods = ImmutableList.of();
    @JsonProperty(value="errorResponseTransform")
    @NotNull
    private ErrorResponseTransformStrategy errorResponseTransformStrategy = NoErrorResponseTransformStrategy.INSTANCE;
    @JsonProperty(value="contentSecurityPolicy")
    private String contentSecurityPolicy;
    @JsonProperty
    private boolean enableHSTS = false;
    @JsonProperty
    @JsonDeserialize(using=UriComplianceDeserializer.class)
    @JsonSerialize(using=UriComplianceSerializer.class)
    private UriCompliance uriCompliance = UriCompliance.LEGACY;
    @JsonProperty
    private boolean enableQueryRequestsQueuing = true;
    @JsonProperty
    private boolean showDetailedJettyErrors = true;
    @JsonProperty
    private boolean enforceStrictSNIHostChecking = true;

    public ServerConfig(int numThreads, int queueSize, boolean enableRequestLimit, @NotNull Period maxIdleTime, long defaultQueryTimeout, long maxScatterGatherBytes, int maxSubqueryRows, String maxSubqueryBytes, boolean useNestedForUnknownTypeInSubquery, long maxQueryTimeout, int maxRequestHeaderSize, @NotNull Period gracefulShutdownTimeout, @NotNull Period unannouncePropagationDelay, int inflateBufferSize, int compressionLevel, boolean enableForwardedRequestCustomizer, @NotNull List<String> allowedHttpMethods, boolean showDetailedJettyErrors, @NotNull ErrorResponseTransformStrategy errorResponseTransformStrategy, @Nullable String contentSecurityPolicy, boolean enableHSTS, @Nullable UriCompliance uriCompliance, boolean enforceStrictSNIHostChecking) {
        this.numThreads = numThreads;
        this.queueSize = queueSize;
        this.enableRequestLimit = enableRequestLimit;
        this.maxIdleTime = maxIdleTime;
        this.defaultQueryTimeout = defaultQueryTimeout;
        this.maxScatterGatherBytes = HumanReadableBytes.valueOf((long)maxScatterGatherBytes);
        this.maxSubqueryRows = maxSubqueryRows;
        this.maxSubqueryBytes = maxSubqueryBytes;
        this.useNestedForUnknownTypeInSubquery = useNestedForUnknownTypeInSubquery;
        this.maxQueryTimeout = maxQueryTimeout;
        this.maxRequestHeaderSize = maxRequestHeaderSize;
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.unannouncePropagationDelay = unannouncePropagationDelay;
        this.inflateBufferSize = inflateBufferSize;
        this.compressionLevel = compressionLevel;
        this.enableForwardedRequestCustomizer = enableForwardedRequestCustomizer;
        this.allowedHttpMethods = allowedHttpMethods;
        this.showDetailedJettyErrors = showDetailedJettyErrors;
        this.errorResponseTransformStrategy = errorResponseTransformStrategy;
        this.contentSecurityPolicy = contentSecurityPolicy;
        this.enableHSTS = enableHSTS;
        this.uriCompliance = uriCompliance != null ? uriCompliance : UriCompliance.LEGACY;
        this.enforceStrictSNIHostChecking = enforceStrictSNIHostChecking;
    }

    public ServerConfig() {
    }

    @VisibleForTesting
    public ServerConfig(boolean enableQueryRequestsQueuing) {
        this.enableQueryRequestsQueuing = enableQueryRequestsQueuing;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public boolean isEnableRequestLimit() {
        return this.enableRequestLimit;
    }

    public Period getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public long getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public long getMaxScatterGatherBytes() {
        return this.maxScatterGatherBytes.getBytes();
    }

    public int getMaxSubqueryRows() {
        return this.maxSubqueryRows;
    }

    public String getMaxSubqueryBytes() {
        return this.maxSubqueryBytes;
    }

    public boolean isuseNestedForUnknownTypeInSubquery() {
        return this.useNestedForUnknownTypeInSubquery;
    }

    public long getMaxQueryTimeout() {
        return this.maxQueryTimeout;
    }

    public int getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    public Period getGracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    public Period getUnannouncePropagationDelay() {
        return this.unannouncePropagationDelay;
    }

    public int getInflateBufferSize() {
        return this.inflateBufferSize;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean isEnableForwardedRequestCustomizer() {
        return this.enableForwardedRequestCustomizer;
    }

    public boolean isShowDetailedJettyErrors() {
        return this.showDetailedJettyErrors;
    }

    public ErrorResponseTransformStrategy getErrorResponseTransformStrategy() {
        return this.errorResponseTransformStrategy;
    }

    @NotNull
    public List<String> getAllowedHttpMethods() {
        return this.allowedHttpMethods;
    }

    public String getContentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    public boolean isEnableHSTS() {
        return this.enableHSTS;
    }

    public boolean isEnableQueryRequestsQueuing() {
        return this.enableQueryRequestsQueuing;
    }

    public UriCompliance getUriCompliance() {
        return this.uriCompliance;
    }

    public boolean isEnforceStrictSNIHostChecking() {
        return this.enforceStrictSNIHostChecking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfig that = (ServerConfig)o;
        return this.numThreads == that.numThreads && this.queueSize == that.queueSize && this.enableRequestLimit == that.enableRequestLimit && this.defaultQueryTimeout == that.defaultQueryTimeout && this.maxSubqueryRows == that.maxSubqueryRows && Objects.equals(this.maxSubqueryBytes, that.maxSubqueryBytes) && this.useNestedForUnknownTypeInSubquery == that.useNestedForUnknownTypeInSubquery && this.maxQueryTimeout == that.maxQueryTimeout && this.maxRequestHeaderSize == that.maxRequestHeaderSize && this.inflateBufferSize == that.inflateBufferSize && this.compressionLevel == that.compressionLevel && this.enableForwardedRequestCustomizer == that.enableForwardedRequestCustomizer && this.showDetailedJettyErrors == that.showDetailedJettyErrors && this.maxIdleTime.equals((Object)that.maxIdleTime) && this.maxScatterGatherBytes.equals((Object)that.maxScatterGatherBytes) && this.gracefulShutdownTimeout.equals((Object)that.gracefulShutdownTimeout) && this.unannouncePropagationDelay.equals((Object)that.unannouncePropagationDelay) && this.allowedHttpMethods.equals(that.allowedHttpMethods) && this.errorResponseTransformStrategy.equals(that.errorResponseTransformStrategy) && Objects.equals(this.contentSecurityPolicy, that.getContentSecurityPolicy()) && this.enableHSTS == that.enableHSTS && this.enableQueryRequestsQueuing == that.enableQueryRequestsQueuing && Objects.equals(this.uriCompliance, that.uriCompliance) && this.enforceStrictSNIHostChecking == that.enforceStrictSNIHostChecking;
    }

    public int hashCode() {
        return Objects.hash(this.numThreads, this.queueSize, this.enableRequestLimit, this.maxIdleTime, this.defaultQueryTimeout, this.maxScatterGatherBytes, this.maxSubqueryRows, this.maxSubqueryBytes, this.useNestedForUnknownTypeInSubquery, this.maxQueryTimeout, this.maxRequestHeaderSize, this.gracefulShutdownTimeout, this.unannouncePropagationDelay, this.inflateBufferSize, this.compressionLevel, this.enableForwardedRequestCustomizer, this.allowedHttpMethods, this.errorResponseTransformStrategy, this.showDetailedJettyErrors, this.contentSecurityPolicy, this.enableHSTS, this.enableQueryRequestsQueuing, this.uriCompliance, this.enforceStrictSNIHostChecking);
    }

    public String toString() {
        return "ServerConfig{numThreads=" + this.numThreads + ", queueSize=" + this.queueSize + ", enableRequestLimit=" + this.enableRequestLimit + ", maxIdleTime=" + String.valueOf(this.maxIdleTime) + ", defaultQueryTimeout=" + this.defaultQueryTimeout + ", maxScatterGatherBytes=" + String.valueOf(this.maxScatterGatherBytes) + ", maxSubqueryRows=" + this.maxSubqueryRows + ", maxSubqueryBytes=" + this.maxSubqueryBytes + ", useNestedForUnknownTypeInSubquery=" + this.useNestedForUnknownTypeInSubquery + ", maxQueryTimeout=" + this.maxQueryTimeout + ", maxRequestHeaderSize=" + this.maxRequestHeaderSize + ", gracefulShutdownTimeout=" + String.valueOf(this.gracefulShutdownTimeout) + ", unannouncePropagationDelay=" + String.valueOf(this.unannouncePropagationDelay) + ", inflateBufferSize=" + this.inflateBufferSize + ", compressionLevel=" + this.compressionLevel + ", enableForwardedRequestCustomizer=" + this.enableForwardedRequestCustomizer + ", allowedHttpMethods=" + String.valueOf(this.allowedHttpMethods) + ", errorResponseTransformStrategy=" + String.valueOf(this.errorResponseTransformStrategy) + ", showDetailedJettyErrors=" + this.showDetailedJettyErrors + ", contentSecurityPolicy=" + this.contentSecurityPolicy + ", enableHSTS=" + this.enableHSTS + ", enableQueryRequestsQueuing=" + this.enableQueryRequestsQueuing + ", uriCompliance=" + String.valueOf(this.uriCompliance) + ", enforceStrictSNIHostChecking=" + this.enforceStrictSNIHostChecking + "}";
    }

    public static int getDefaultNumThreads() {
        return Math.max(10, JvmUtils.getRuntimeInfo().getAvailableProcessors() * 17 / 16 + 2) + 30;
    }

    public static class UriComplianceSerializer
    extends JsonSerializer<UriCompliance> {
        public void serialize(UriCompliance value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getName());
        }
    }

    public static class UriComplianceDeserializer
    extends JsonDeserializer<UriCompliance> {
        public UriCompliance deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String value = p.getValueAsString();
            return UriCompliance.valueOf((String)value);
        }
    }
}

