/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.compaction.CompactionTaskStatus;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class CompactionStatusTracker {
    private static final Duration MAX_STATUS_RETAIN_DURATION = Duration.standardHours((long)12L);
    private final ConcurrentHashMap<String, DatasourceStatus> datasourceStatuses = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CompactionCandidate> submittedTaskIdToSegments = new ConcurrentHashMap();
    private final AtomicReference<DateTime> segmentSnapshotTime = new AtomicReference();

    public void stop() {
        this.datasourceStatuses.clear();
    }

    public void removeDatasource(String datasource) {
        this.datasourceStatuses.remove(datasource);
    }

    public CompactionTaskStatus getLatestTaskStatus(CompactionCandidate candidates) {
        return this.datasourceStatuses.getOrDefault((Object)candidates.getDataSource(), (DatasourceStatus)DatasourceStatus.EMPTY).intervalToTaskStatus.get(candidates.getCompactionInterval());
    }

    public Set<String> getSubmittedTaskIds() {
        return this.submittedTaskIdToSegments.keySet();
    }

    public CompactionStatus computeCompactionStatus(CompactionCandidate candidate, CompactionCandidateSearchPolicy searchPolicy) {
        CompactionTaskStatus lastTaskStatus = this.getLatestTaskStatus(candidate);
        if (lastTaskStatus != null && lastTaskStatus.getState() == TaskState.RUNNING) {
            return CompactionStatus.running("Task for interval is already running");
        }
        DateTime snapshotTime = this.segmentSnapshotTime.get();
        if (lastTaskStatus != null && lastTaskStatus.getState() == TaskState.SUCCESS && snapshotTime != null && snapshotTime.isBefore((ReadableInstant)lastTaskStatus.getUpdatedTime())) {
            return CompactionStatus.skipped("Segment timeline not updated since last compaction task succeeded", new Object[0]);
        }
        CompactionCandidateSearchPolicy.Eligibility eligibility = searchPolicy.checkEligibilityForCompaction(candidate, lastTaskStatus);
        if (eligibility.isEligible()) {
            return CompactionStatus.pending("Not compacted yet", new Object[0]);
        }
        return CompactionStatus.skipped("Rejected by search policy: %s", eligibility.getReason());
    }

    public void onCompactionStatusComputed(CompactionCandidate candidateSegments, DataSourceCompactionConfig config) {
    }

    public void onSegmentTimelineUpdated(DateTime snapshotTime) {
        this.segmentSnapshotTime.set(snapshotTime);
    }

    public void resetActiveDatasources(Set<String> compactionEnabledDatasources) {
        compactionEnabledDatasources.forEach(dataSource -> this.getOrComputeDatasourceStatus((String)dataSource).cleanupStaleTaskStatuses());
        HashSet allDatasources = new HashSet(this.datasourceStatuses.keySet());
        allDatasources.forEach(datasource -> {
            if (!compactionEnabledDatasources.contains(datasource)) {
                this.datasourceStatuses.remove(datasource);
            }
        });
    }

    public void onTaskSubmitted(String taskId, CompactionCandidate candidateSegments) {
        this.submittedTaskIdToSegments.put(taskId, candidateSegments);
        this.getOrComputeDatasourceStatus(candidateSegments.getDataSource()).handleSubmittedTask(candidateSegments);
    }

    public void onTaskFinished(String taskId, TaskStatus taskStatus) {
        if (!taskStatus.isComplete()) {
            return;
        }
        CompactionCandidate candidateSegments = this.submittedTaskIdToSegments.remove(taskId);
        if (candidateSegments == null) {
            return;
        }
        Interval compactionInterval = candidateSegments.getCompactionInterval();
        this.getOrComputeDatasourceStatus(candidateSegments.getDataSource()).handleCompletedTask(compactionInterval, taskStatus);
    }

    private DatasourceStatus getOrComputeDatasourceStatus(String datasource) {
        return this.datasourceStatuses.computeIfAbsent(datasource, ds -> new DatasourceStatus());
    }

    private static class DatasourceStatus {
        static final DatasourceStatus EMPTY = new DatasourceStatus();
        final ConcurrentHashMap<Interval, CompactionTaskStatus> intervalToTaskStatus = new ConcurrentHashMap();

        private DatasourceStatus() {
        }

        void handleCompletedTask(Interval compactionInterval, TaskStatus taskStatus) {
            CompactionTaskStatus lastKnownStatus = this.intervalToTaskStatus.get(compactionInterval);
            DateTime now = DateTimes.nowUtc();
            CompactionTaskStatus updatedStatus = taskStatus.isSuccess() ? new CompactionTaskStatus(TaskState.SUCCESS, now, 0) : (lastKnownStatus == null || lastKnownStatus.getState().isSuccess() ? new CompactionTaskStatus(TaskState.FAILED, now, 1) : new CompactionTaskStatus(TaskState.FAILED, now, lastKnownStatus.getNumConsecutiveFailures() + 1));
            this.intervalToTaskStatus.put(compactionInterval, updatedStatus);
        }

        void handleSubmittedTask(CompactionCandidate candidateSegments) {
            Interval interval = candidateSegments.getCompactionInterval();
            CompactionTaskStatus lastStatus = this.intervalToTaskStatus.get(interval);
            DateTime now = DateTimes.nowUtc();
            if (lastStatus == null || !lastStatus.getState().isFailure()) {
                this.intervalToTaskStatus.put(interval, new CompactionTaskStatus(TaskState.RUNNING, now, 0));
            } else {
                this.intervalToTaskStatus.put(interval, new CompactionTaskStatus(TaskState.RUNNING, now, lastStatus.getNumConsecutiveFailures()));
            }
        }

        void cleanupStaleTaskStatuses() {
            DateTime now = DateTimes.nowUtc();
            HashSet staleIntervals = new HashSet();
            this.intervalToTaskStatus.forEach((interval, taskStatus) -> {
                if (taskStatus.getUpdatedTime().plus((ReadableDuration)MAX_STATUS_RETAIN_DURATION).isBefore((ReadableInstant)now)) {
                    staleIntervals.add(interval);
                }
            });
            staleIntervals.forEach(this.intervalToTaskStatus::remove);
        }
    }
}

