/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSTABLEPERMSRowFactory
extends PermissionsCatalogRowFactory {
    static final String TABLENAME_STRING = "SYSTABLEPERMS";
    private static final int TABLEPERMSID_COL_NUM = 1;
    private static final int GRANTEE_COL_NUM = 2;
    private static final int GRANTOR_COL_NUM = 3;
    private static final int TABLEID_COL_NUM = 4;
    private static final int SELECTPRIV_COL_NUM = 5;
    private static final int DELETEPRIV_COL_NUM = 6;
    private static final int INSERTPRIV_COL_NUM = 7;
    private static final int UPDATEPRIV_COL_NUM = 8;
    private static final int REFERENCESPRIV_COL_NUM = 9;
    private static final int TRIGGERPRIV_COL_NUM = 10;
    private static final int COLUMN_COUNT = 10;
    public static final int GRANTEE_TABLE_GRANTOR_INDEX_NUM = 0;
    public static final int TABLEPERMSID_INDEX_NUM = 1;
    public static final int TABLEID_INDEX_NUM = 2;
    private static final int[][] indexColumnPositions = new int[][]{{2, 4, 3}, {1}, {4}};
    public static final int GRANTEE_COL_NUM_IN_GRANTEE_TABLE_GRANTOR_INDEX = 1;
    private static final boolean[] indexUniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"b8450018-0103-0e39-b8e7-00000010f010", "004b0019-0103-0e39-b8e7-00000010f010", "c851401a-0103-0e39-b8e7-00000010f010", "80220011-010c-426e-c599-0000000f1120", "f81e0010-010c-bc85-060d-000000109ab8"};

    SYSTABLEPERMSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(10, TABLENAME_STRING, indexColumnPositions, indexUniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        Object object;
        DataValueDescriptor dataValueDescriptor = null;
        DataValueDescriptor dataValueDescriptor2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (tupleDescriptor == null) {
            dataValueDescriptor = this.getNullAuthorizationID();
            dataValueDescriptor2 = this.getNullAuthorizationID();
        } else {
            object = (TablePermsDescriptor)tupleDescriptor;
            UUID uUID = ((PermissionsDescriptor)object).getUUID();
            if (uUID == null) {
                uUID = this.getUUIDFactory().createUUID();
                ((PermissionsDescriptor)object).setUUID(uUID);
            }
            string = uUID.toString();
            dataValueDescriptor = this.getAuthorizationID(((PermissionsDescriptor)object).getGrantee());
            dataValueDescriptor2 = this.getAuthorizationID(((PermissionsDescriptor)object).getGrantor());
            string2 = ((TablePermsDescriptor)object).getTableUUID().toString();
            string3 = ((TablePermsDescriptor)object).getSelectPriv();
            string4 = ((TablePermsDescriptor)object).getDeletePriv();
            string5 = ((TablePermsDescriptor)object).getInsertPriv();
            string6 = ((TablePermsDescriptor)object).getUpdatePriv();
            string7 = ((TablePermsDescriptor)object).getReferencesPriv();
            string8 = ((TablePermsDescriptor)object).getTriggerPriv();
        }
        object = this.getExecutionFactory().getValueRow(10);
        object.setColumn(1, new SQLChar(string));
        object.setColumn(2, dataValueDescriptor);
        object.setColumn(3, dataValueDescriptor2);
        object.setColumn(4, new SQLChar(string2));
        object.setColumn(5, new SQLChar(string3));
        object.setColumn(6, new SQLChar(string4));
        object.setColumn(7, new SQLChar(string5));
        object.setColumn(8, new SQLChar(string6));
        object.setColumn(9, new SQLChar(string7));
        object.setColumn(10, new SQLChar(string8));
        return object;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        String string = execRow.getColumn(1).getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        String string2 = execRow.getColumn(4).getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string2);
        String string3 = execRow.getColumn(5).getString();
        String string4 = execRow.getColumn(6).getString();
        String string5 = execRow.getColumn(7).getString();
        String string6 = execRow.getColumn(8).getString();
        String string7 = execRow.getColumn(9).getString();
        String string8 = execRow.getColumn(10).getString();
        TablePermsDescriptor tablePermsDescriptor = new TablePermsDescriptor(dataDictionary, this.getAuthorizationID(execRow, 2), this.getAuthorizationID(execRow, 3), uUID2, string3, string4, string5, string6, string7, string8);
        tablePermsDescriptor.setUUID(uUID);
        return tablePermsDescriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TABLEPERMSID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIndicatorColumn("SELECTPRIV"), SystemColumnImpl.getIndicatorColumn("DELETEPRIV"), SystemColumnImpl.getIndicatorColumn("INSERTPRIV"), SystemColumnImpl.getIndicatorColumn("UPDATEPRIV"), SystemColumnImpl.getIndicatorColumn("REFERENCESPRIV"), SystemColumnImpl.getIndicatorColumn("TRIGGERPRIV")};
    }

    @Override
    public ExecIndexRow buildIndexKeyRow(int n, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        ExecIndexRow execIndexRow = null;
        switch (n) {
            case 0: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(2);
                execIndexRow.setColumn(1, this.getAuthorizationID(permissionsDescriptor.getGrantee()));
                String string = ((TablePermsDescriptor)permissionsDescriptor).getTableUUID().toString();
                execIndexRow.setColumn(2, new SQLChar(string));
                break;
            }
            case 1: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(1);
                String string = permissionsDescriptor.getObjectID().toString();
                execIndexRow.setColumn(1, new SQLChar(string));
                break;
            }
            case 2: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(1);
                String string = ((TablePermsDescriptor)permissionsDescriptor).getTableUUID().toString();
                execIndexRow.setColumn(1, new SQLChar(string));
            }
        }
        return execIndexRow;
    }

    @Override
    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    @Override
    public int orPermissions(ExecRow execRow, PermissionsDescriptor permissionsDescriptor, boolean[] blArray) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = (TablePermsDescriptor)permissionsDescriptor;
        int n = 0;
        n += this.orOnePermission(execRow, blArray, 5, tablePermsDescriptor.getSelectPriv());
        n += this.orOnePermission(execRow, blArray, 6, tablePermsDescriptor.getDeletePriv());
        n += this.orOnePermission(execRow, blArray, 7, tablePermsDescriptor.getInsertPriv());
        n += this.orOnePermission(execRow, blArray, 8, tablePermsDescriptor.getUpdatePriv());
        n += this.orOnePermission(execRow, blArray, 9, tablePermsDescriptor.getReferencesPriv());
        return n += this.orOnePermission(execRow, blArray, 10, tablePermsDescriptor.getTriggerPriv());
    }

    private int orOnePermission(ExecRow execRow, boolean[] blArray, int n, String string) throws StandardException {
        if (string.charAt(0) == 'N') {
            return 0;
        }
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(n);
        char c = dataValueDescriptor.getString().charAt(0);
        if (c == 'Y' || c == string.charAt(0)) {
            return 0;
        }
        dataValueDescriptor.setValue(string);
        blArray[n - 1] = true;
        return 1;
    }

    @Override
    public int removePermissions(ExecRow execRow, PermissionsDescriptor permissionsDescriptor, boolean[] blArray) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = (TablePermsDescriptor)permissionsDescriptor;
        int n = 0;
        boolean bl = this.removeOnePermission(execRow, blArray, 5, tablePermsDescriptor.getSelectPriv()) | this.removeOnePermission(execRow, blArray, 6, tablePermsDescriptor.getDeletePriv()) | this.removeOnePermission(execRow, blArray, 7, tablePermsDescriptor.getInsertPriv()) | this.removeOnePermission(execRow, blArray, 8, tablePermsDescriptor.getUpdatePriv()) | this.removeOnePermission(execRow, blArray, 9, tablePermsDescriptor.getReferencesPriv()) | this.removeOnePermission(execRow, blArray, 10, tablePermsDescriptor.getTriggerPriv());
        if (!bl) {
            return -1;
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    private boolean removeOnePermission(ExecRow execRow, boolean[] blArray, int n, String string) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(n);
        char c = dataValueDescriptor.getString().charAt(0);
        if (string.charAt(0) == 'N') {
            return c != 'N';
        }
        if (c != 'N') {
            dataValueDescriptor.setValue("N");
            blArray[n - 1] = true;
        }
        return false;
    }

    @Override
    public void setUUIDOfThePassedDescriptor(ExecRow execRow, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        permissionsDescriptor.setUUID(this.getUUIDFactory().recreateUUID(dataValueDescriptor.getString()));
    }
}

