/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.serde.cell.BlockIndexWriter;
import org.apache.druid.segment.serde.cell.IntSerializer;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class BlockCompressedPayloadSerializer
implements Serializer {
    private final IntSerializer intSerializer = new IntSerializer();
    private final BlockIndexWriter blockIndexWriter;
    private final WriteOutBytes dataOutBytes;

    public BlockCompressedPayloadSerializer(BlockIndexWriter blockIndexWriter, WriteOutBytes dataOutBytes) {
        this.blockIndexWriter = blockIndexWriter;
        this.dataOutBytes = dataOutBytes;
    }

    @Override
    public void writeTo(WritableByteChannel channel, @Nullable SegmentFileBuilder fileBuilder) throws IOException {
        this.blockIndexWriter.transferTo(channel);
        channel.write(this.intSerializer.serialize(this.dataOutBytes.size()));
        this.dataOutBytes.writeTo(channel);
    }

    @Override
    public long getSerializedSize() {
        return this.blockIndexWriter.getSerializedSize() + (long)this.intSerializer.getSerializedSize() + (long)Ints.checkedCast((long)this.dataOutBytes.size());
    }
}

