/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAndSize;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.AppendableIndexBuilder;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.FactsHolder;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnHeapAggregateProjection;
import org.apache.druid.segment.projections.AggregateProjectionSchema;
import org.apache.druid.segment.projections.Projections;
import org.apache.druid.segment.projections.QueryableProjection;
import org.apache.druid.utils.JvmUtils;

public class OnheapIncrementalIndex
extends IncrementalIndex {
    private static final Logger log = new Logger(OnheapIncrementalIndex.class);
    static final int ROUGH_OVERHEAD_PER_MAP_ENTRY = 44;
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final FactsHolder facts;
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    protected final int maxRowCount;
    protected final long maxBytesInMemory;
    @Nullable
    private Map<String, ColumnSelectorFactory> selectors;
    @Nullable
    private Map<String, ColumnSelectorFactory> combiningAggSelectors;
    @Nullable
    private String outOfRowsReason = null;
    private final SortedSet<AggregateProjectionMetadata> aggregateProjections;
    private final HashMap<String, OnHeapAggregateProjection> projections;

    OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, int maxRowCount, long maxBytesInMemory, boolean preserveExistingMetrics) {
        super(incrementalIndexSchema, preserveExistingMetrics);
        this.maxRowCount = maxRowCount;
        long l = this.maxBytesInMemory = maxBytesInMemory == 0L ? Long.MAX_VALUE : maxBytesInMemory;
        this.facts = incrementalIndexSchema.isRollup() ? new RollupFactsHolder(this.dimsComparator(), this.getDimensions(), this.timePosition == 0) : (this.timePosition == 0 ? new PlainTimeOrderedFactsHolder(this.dimsComparator()) : new PlainNonTimeOrderedFactsHolder(this.dimsComparator()));
        this.aggregateProjections = new ObjectAVLTreeSet(AggregateProjectionMetadata.COMPARATOR);
        this.projections = new HashMap();
        this.initializeProjections(incrementalIndexSchema);
    }

    private void initializeProjections(IncrementalIndexSchema incrementalIndexSchema) {
        for (AggregateProjectionSpec projectionSpec : incrementalIndexSchema.getProjections()) {
            AggregateProjectionSchema schema = projectionSpec.toMetadataSchema();
            this.aggregateProjections.add(new AggregateProjectionMetadata(schema, 0));
            if (this.projections.containsKey(projectionSpec.getName())) {
                throw DruidException.defensive("duplicate projection[%s]", projectionSpec.getName());
            }
            OnHeapAggregateProjection projection = new OnHeapAggregateProjection(projectionSpec, this::getDimension, metric -> {
                IncrementalIndex.MetricDesc desc = this.getMetric((String)metric);
                if (desc != null) {
                    return this.getMetricAggs()[desc.getIndex()];
                }
                return null;
            }, incrementalIndexSchema.getMinTimestamp());
            this.projections.put(projectionSpec.getName(), projection);
        }
    }

    @Override
    public FactsHolder getFacts() {
        return this.facts;
    }

    @Override
    public Metadata getMetadata() {
        if (this.aggregateProjections.isEmpty()) {
            return super.getMetadata();
        }
        List<AggregateProjectionMetadata> projectionMetadata = this.projections.values().stream().map(OnHeapAggregateProjection::toMetadata).collect(Collectors.toList());
        return super.getMetadata().withProjections(projectionMetadata);
    }

    @Override
    protected void initAggs(AggregatorFactory[] metrics, IncrementalIndex.InputRowHolder inputRowHolder) {
        CachingColumnSelectorFactory nonComplexColumnSelectorFactory = null;
        this.selectors = new HashMap<String, ColumnSelectorFactory>();
        this.combiningAggSelectors = new HashMap<String, ColumnSelectorFactory>();
        for (AggregatorFactory agg : metrics) {
            CachingColumnSelectorFactory factory;
            if (agg.getIntermediateType().is(ValueType.COMPLEX)) {
                factory = new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(agg, inputRowHolder));
            } else {
                if (nonComplexColumnSelectorFactory == null) {
                    nonComplexColumnSelectorFactory = new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(null, inputRowHolder));
                }
                factory = nonComplexColumnSelectorFactory;
            }
            this.selectors.put(agg.getName(), factory);
        }
        if (this.preserveExistingMetrics) {
            for (AggregatorFactory agg : metrics) {
                CachingColumnSelectorFactory factory;
                AggregatorFactory combiningAgg = agg.getCombiningFactory();
                if (combiningAgg.getIntermediateType().is(ValueType.COMPLEX)) {
                    factory = new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(combiningAgg, inputRowHolder));
                } else {
                    if (nonComplexColumnSelectorFactory == null) {
                        nonComplexColumnSelectorFactory = new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(null, inputRowHolder));
                    }
                    factory = nonComplexColumnSelectorFactory;
                }
                this.combiningAggSelectors.put(combiningAgg.getName(), factory);
            }
        }
    }

    @Override
    protected IncrementalIndex.AddToFactsResult addToFacts(IncrementalIndexRow key, IncrementalIndex.InputRowHolder inputRowHolder) {
        Aggregator[] aggs;
        ArrayList<String> parseExceptionMessages = new ArrayList<String>();
        AtomicLong totalSizeInBytes = this.getBytesInMemory();
        for (OnHeapAggregateProjection projection : this.projections.values()) {
            projection.addToFacts(key, inputRowHolder.getRow(), parseExceptionMessages, totalSizeInBytes);
        }
        int priorIndex = this.facts.getPriorIndex(key);
        AggregatorFactory[] metrics = this.getMetricAggs();
        AtomicInteger numEntries = this.getNumEntries();
        if (-1 != priorIndex) {
            aggs = this.aggregators.get(priorIndex);
            long aggSizeDelta = this.doAggregate(metrics, aggs, inputRowHolder, parseExceptionMessages);
            totalSizeInBytes.addAndGet(aggSizeDelta);
        } else {
            aggs = this.preserveExistingMetrics ? new Aggregator[metrics.length * 2] : new Aggregator[metrics.length];
            long aggSizeForRow = this.factorizeAggs(metrics, aggs);
            aggSizeForRow += this.doAggregate(metrics, aggs, inputRowHolder, parseExceptionMessages);
            int rowIndex = this.indexIncrement.getAndIncrement();
            this.aggregators.put(rowIndex, aggs);
            int prev = this.facts.putIfAbsent(key, rowIndex);
            if (-1 != prev) {
                throw DruidException.defensive("Encountered existing fact entry for new key, possible concurrent add?", new Object[0]);
            }
            numEntries.incrementAndGet();
            long estimatedSizeOfAggregators = aggSizeForRow;
            long rowSize = key.estimateBytesInMemory() + estimatedSizeOfAggregators + 44L;
            totalSizeInBytes.addAndGet(rowSize);
        }
        return new IncrementalIndex.AddToFactsResult(numEntries.get(), totalSizeInBytes.get(), parseExceptionMessages);
    }

    @Override
    public int getLastRowIndex() {
        return this.indexIncrement.get() - 1;
    }

    private long factorizeAggs(AggregatorFactory[] metrics, Aggregator[] aggs) {
        long totalInitialSizeBytes = 0L;
        long aggReferenceSize = 8L;
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            AggregatorAndSize aggregatorAndSize = agg.factorizeWithSize(this.selectors.get(agg.getName()));
            aggs[i] = aggregatorAndSize.getAggregator();
            totalInitialSizeBytes += aggregatorAndSize.getInitialSizeBytes();
            totalInitialSizeBytes += 8L;
            if (!this.preserveExistingMetrics) continue;
            AggregatorFactory combiningAgg = agg.getCombiningFactory();
            AggregatorAndSize combiningAggAndSize = combiningAgg.factorizeWithSize(this.combiningAggSelectors.get(combiningAgg.getName()));
            aggs[i + metrics.length] = combiningAggAndSize.getAggregator();
            totalInitialSizeBytes += combiningAggAndSize.getInitialSizeBytes();
            totalInitialSizeBytes += 8L;
        }
        return totalInitialSizeBytes;
    }

    private long doAggregate(AggregatorFactory[] metrics, Aggregator[] aggs, IncrementalIndex.InputRowHolder inputRowHolder, List<String> parseExceptionsHolder) {
        return OnheapIncrementalIndex.doAggregate(metrics, aggs, inputRowHolder, parseExceptionsHolder, this.preserveExistingMetrics);
    }

    static long doAggregate(AggregatorFactory[] metrics, Aggregator[] aggs, IncrementalIndex.InputRowHolder inputRowHolder, List<String> parseExceptionsHolder, boolean preserveExistingMetrics) {
        long totalIncrementalBytes = 0L;
        for (int i = 0; i < metrics.length; ++i) {
            Aggregator agg = preserveExistingMetrics && inputRowHolder.getRow() instanceof MapBasedRow && ((MapBasedRow)((Object)inputRowHolder.getRow())).getEvent().containsKey(metrics[i].getName()) ? aggs[i + metrics.length] : aggs[i];
            try {
                totalIncrementalBytes += agg.aggregateWithSize();
                continue;
            }
            catch (ParseException e) {
                if (preserveExistingMetrics) {
                    log.warn(e, "Failing ingestion as preserveExistingMetrics is enabled but selector of aggregator[%s] received incompatible type.", metrics[i].getName());
                    throw e;
                }
                log.debug(e, "Encountered parse error, skipping aggregator[%s].", metrics[i].getName());
                parseExceptionsHolder.add(e.getMessage());
            }
        }
        return totalIncrementalBytes;
    }

    private void closeAggregators() {
        Closer closer = Closer.create();
        for (Aggregator[] aggs : this.aggregators.values()) {
            for (Aggregator agg : aggs) {
                closer.register(agg);
            }
        }
        try {
            closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public QueryableProjection<IncrementalIndexRowSelector> getProjection(CursorBuildSpec buildSpec) {
        return Projections.findMatchingProjection(buildSpec, this.aggregateProjections, this.getInterval(), (specName, columnName) -> this.projections.get(specName).getDimensionsMap().containsKey(columnName) || this.getColumnCapabilities(columnName) == null, this.projections::get);
    }

    @Override
    public IncrementalIndexRowSelector getProjection(String name) {
        return this.projections.get(name);
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean countCheck = this.numRows() < this.maxRowCount;
        boolean sizeCheck = this.maxBytesInMemory <= 0L || this.getBytesInMemory().get() < this.maxBytesInMemory;
        boolean bl = canAdd = countCheck && sizeCheck;
        if (!countCheck && !sizeCheck) {
            this.outOfRowsReason = StringUtils.format("Maximum number of rows [%d] and maximum size in bytes [%d] reached", this.maxRowCount, this.maxBytesInMemory);
        } else if (!countCheck) {
            this.outOfRowsReason = StringUtils.format("Maximum number of rows [%d] reached", this.maxRowCount);
        } else if (!sizeCheck) {
            this.outOfRowsReason = StringUtils.format("Maximum size in bytes [%d] reached", this.maxBytesInMemory);
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return ((Number)this.getMetricHelper(this.getMetricAggs(), this.aggregators.get(rowOffset), aggOffset, Aggregator::getFloat)).floatValue();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return ((Number)this.getMetricHelper(this.getMetricAggs(), this.aggregators.get(rowOffset), aggOffset, Aggregator::getLong)).longValue();
    }

    @Override
    public double getMetricDoubleValue(int rowOffset, int aggOffset) {
        return ((Number)this.getMetricHelper(this.getMetricAggs(), this.aggregators.get(rowOffset), aggOffset, Aggregator::getDouble)).doubleValue();
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.getMetricHelper(this.getMetricAggs(), this.aggregators.get(rowOffset), aggOffset, Aggregator::get);
    }

    @Override
    public boolean isNull(int rowOffset, int aggOffset) {
        Aggregator[] aggs = this.aggregators.get(rowOffset);
        if (this.preserveExistingMetrics) {
            return aggs[aggOffset].isNull() && aggs[aggOffset + this.getMetricAggs().length].isNull();
        }
        return aggs[aggOffset].isNull();
    }

    @Override
    public Iterable<Row> iterableWithPostAggregations(@Nullable List<PostAggregator> postAggs, boolean descending) {
        AggregatorFactory[] metrics = this.getMetricAggs();
        return () -> {
            List<IncrementalIndex.DimensionDesc> dimensions = this.getDimensions();
            return Iterators.transform(this.getFacts().iterator(descending), incrementalIndexRow -> {
                int rowOffset = incrementalIndexRow.getRowIndex();
                Object[] theDims = incrementalIndexRow.getDims();
                LinkedHashMap theVals = Maps.newLinkedHashMap();
                for (int i = 0; i < theDims.length; ++i) {
                    Object dim = theDims[i];
                    IncrementalIndex.DimensionDesc dimensionDesc = (IncrementalIndex.DimensionDesc)dimensions.get(i);
                    if (dimensionDesc == null) continue;
                    String dimensionName = dimensionDesc.getName();
                    DimensionHandler<?, ?, ?> handler = dimensionDesc.getHandler();
                    if (dim == null || handler.getLengthOfEncodedKeyComponent(dim) == 0) {
                        theVals.put(dimensionName, null);
                        continue;
                    }
                    DimensionIndexer<?, ?, ?> indexer = dimensionDesc.getIndexer();
                    Object rowVals = indexer.convertUnsortedEncodedKeyComponentToActualList(dim);
                    theVals.put(dimensionName, rowVals);
                }
                Aggregator[] aggs = this.aggregators.get(rowOffset);
                int aggLength = this.preserveExistingMetrics ? aggs.length / 2 : aggs.length;
                for (int i = 0; i < aggLength; ++i) {
                    theVals.put(metrics[i].getName(), this.getMetricHelper(metrics, aggs, i, Aggregator::get));
                }
                if (postAggs != null) {
                    for (PostAggregator postAgg : postAggs) {
                        theVals.put(postAgg.getName(), postAgg.compute(theVals));
                    }
                }
                return new MapBasedRow(incrementalIndexRow.getTimestamp(), (Map<String, Object>)theVals);
            });
        };
    }

    @Nullable
    private <T> Object getMetricHelper(AggregatorFactory[] metrics, Aggregator[] aggs, int aggOffset, Function<Aggregator, T> getMetricTypeFunction) {
        if (this.preserveExistingMetrics) {
            if (aggs[aggOffset].isNull()) {
                return getMetricTypeFunction.apply(aggs[aggOffset + metrics.length]);
            }
            if (aggs[aggOffset + metrics.length].isNull()) {
                return getMetricTypeFunction.apply(aggs[aggOffset]);
            }
            AggregatorFactory aggregatorFactory = metrics[aggOffset];
            T aggregatedFromSource = getMetricTypeFunction.apply(aggs[aggOffset]);
            T aggregatedFromCombined = getMetricTypeFunction.apply(aggs[aggOffset + metrics.length]);
            return aggregatorFactory.combine(aggregatedFromSource, aggregatedFromCombined);
        }
        return getMetricTypeFunction.apply(aggs[aggOffset]);
    }

    @Override
    public void close() {
        super.close();
        this.closeAggregators();
        this.aggregators.clear();
        this.facts.clear();
        if (this.selectors != null) {
            this.selectors.clear();
        }
        if (this.combiningAggSelectors != null) {
            this.combiningAggSelectors.clear();
        }
    }

    static final class RollupFactsHolder
    implements FactsHolder {
        private final ConcurrentNavigableMap<IncrementalIndexRow, IncrementalIndexRow> facts;
        private final List<IncrementalIndex.DimensionDesc> dimensionDescsList;
        private final boolean timeOrdered;
        private volatile long minTime = DateTimes.MAX.getMillis();
        private volatile long maxTime = DateTimes.MIN.getMillis();

        RollupFactsHolder(Comparator<IncrementalIndexRow> incrementalIndexRowComparator, List<IncrementalIndex.DimensionDesc> dimensionDescsList, boolean timeOrdered) {
            this.facts = new ConcurrentSkipListMap<IncrementalIndexRow, IncrementalIndexRow>(incrementalIndexRowComparator);
            this.dimensionDescsList = dimensionDescsList;
            this.timeOrdered = timeOrdered;
        }

        @Override
        public int getPriorIndex(IncrementalIndexRow key) {
            IncrementalIndexRow row = (IncrementalIndexRow)this.facts.get(key);
            return row == null ? -1 : row.getRowIndex();
        }

        @Override
        public long getMinTimeMillis() {
            return this.minTime;
        }

        @Override
        public long getMaxTimeMillis() {
            return this.maxTime;
        }

        @Override
        public Iterator<IncrementalIndexRow> iterator(boolean descending) {
            if (descending) {
                return this.facts.descendingMap().keySet().iterator();
            }
            return this.keySet().iterator();
        }

        @Override
        public Iterable<IncrementalIndexRow> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            if (this.timeOrdered) {
                IncrementalIndexRow start = new IncrementalIndexRow(timeStart, new Object[0], this.dimensionDescsList);
                IncrementalIndexRow end = new IncrementalIndexRow(timeEnd, new Object[0], this.dimensionDescsList);
                SortedMap subMap = this.facts.subMap((Object)start, (Object)end);
                SortedMap rangeMap = descending ? subMap.descendingMap() : subMap;
                return rangeMap.keySet();
            }
            return Iterables.filter((Iterable)this.facts.keySet(), row -> row.timestamp >= timeStart && row.timestamp < timeEnd);
        }

        @Override
        public Iterable<IncrementalIndexRow> keySet() {
            return this.facts.keySet();
        }

        @Override
        public Iterable<IncrementalIndexRow> persistIterable() {
            return this.keySet();
        }

        @Override
        public int putIfAbsent(IncrementalIndexRow key, int rowIndex) {
            key.setRowIndex(rowIndex);
            this.minTime = Math.min(this.minTime, key.timestamp);
            this.maxTime = Math.max(this.maxTime, key.timestamp);
            IncrementalIndexRow prev = this.facts.putIfAbsent(key, key);
            return prev == null ? -1 : prev.getRowIndex();
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    static final class PlainTimeOrderedFactsHolder
    implements FactsHolder {
        private final ConcurrentNavigableMap<Long, Deque<IncrementalIndexRow>> facts = new ConcurrentSkipListMap<Long, Deque<IncrementalIndexRow>>();
        private final Comparator<IncrementalIndexRow> incrementalIndexRowComparator;

        public PlainTimeOrderedFactsHolder(Comparator<IncrementalIndexRow> incrementalIndexRowComparator) {
            this.incrementalIndexRowComparator = incrementalIndexRowComparator;
        }

        @Override
        public int getPriorIndex(IncrementalIndexRow key) {
            return -1;
        }

        @Override
        public long getMinTimeMillis() {
            return (Long)this.facts.firstKey();
        }

        @Override
        public long getMaxTimeMillis() {
            return (Long)this.facts.lastKey();
        }

        @Override
        public Iterator<IncrementalIndexRow> iterator(boolean descending) {
            if (descending) {
                return this.timeOrderedConcat(this.facts.descendingMap().values(), true).iterator();
            }
            return this.timeOrderedConcat(this.facts.values(), false).iterator();
        }

        @Override
        public Iterable<IncrementalIndexRow> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            SortedMap subMap = this.facts.subMap((Object)timeStart, (Object)timeEnd);
            SortedMap rangeMap = descending ? subMap.descendingMap() : subMap;
            return this.timeOrderedConcat(rangeMap.values(), descending);
        }

        private Iterable<IncrementalIndexRow> timeOrderedConcat(Iterable<Deque<IncrementalIndexRow>> iterable, boolean descending) {
            return () -> Iterators.concat((Iterator)Iterators.transform(iterable.iterator(), input -> descending ? input.descendingIterator() : input.iterator()));
        }

        private Stream<IncrementalIndexRow> timeAndDimsOrderedConcat(Collection<Deque<IncrementalIndexRow>> rowGroups) {
            return rowGroups.stream().flatMap(Collection::stream).sorted(this.incrementalIndexRowComparator);
        }

        @Override
        public Iterable<IncrementalIndexRow> keySet() {
            return this.timeOrderedConcat(this.facts.values(), false);
        }

        @Override
        public Iterable<IncrementalIndexRow> persistIterable() {
            return () -> this.timeAndDimsOrderedConcat(this.facts.values()).iterator();
        }

        @Override
        public int putIfAbsent(IncrementalIndexRow key, int rowIndex) {
            Long time = key.getTimestamp();
            Deque rows = (Deque)this.facts.get(time);
            if (rows == null) {
                this.facts.putIfAbsent(time, new ConcurrentLinkedDeque());
                rows = (Deque)this.facts.get(time);
            }
            key.setRowIndex(rowIndex);
            rows.add(key);
            return -1;
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    static final class PlainNonTimeOrderedFactsHolder
    implements FactsHolder {
        private final Deque<IncrementalIndexRow> facts;
        private final Comparator<IncrementalIndexRow> incrementalIndexRowComparator;
        private volatile long minTime = DateTimes.MAX.getMillis();
        private volatile long maxTime = DateTimes.MIN.getMillis();

        public PlainNonTimeOrderedFactsHolder(Comparator<IncrementalIndexRow> incrementalIndexRowComparator) {
            this.facts = new ArrayDeque<IncrementalIndexRow>();
            this.incrementalIndexRowComparator = incrementalIndexRowComparator;
        }

        @Override
        public int getPriorIndex(IncrementalIndexRow key) {
            return -1;
        }

        @Override
        public long getMinTimeMillis() {
            return this.minTime;
        }

        @Override
        public long getMaxTimeMillis() {
            return this.maxTime;
        }

        @Override
        public Iterator<IncrementalIndexRow> iterator(boolean descending) {
            return descending ? this.facts.descendingIterator() : this.facts.iterator();
        }

        @Override
        public Iterable<IncrementalIndexRow> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            return Iterables.filter(() -> this.iterator(descending), row -> row.timestamp >= timeStart && row.timestamp < timeEnd);
        }

        @Override
        public Iterable<IncrementalIndexRow> keySet() {
            return this.facts;
        }

        @Override
        public Iterable<IncrementalIndexRow> persistIterable() {
            ArrayList<IncrementalIndexRow> sortedFacts = new ArrayList<IncrementalIndexRow>(this.facts);
            sortedFacts.sort(this.incrementalIndexRowComparator);
            return sortedFacts;
        }

        @Override
        public int putIfAbsent(IncrementalIndexRow key, int rowIndex) {
            key.setRowIndex(rowIndex);
            this.minTime = Math.min(this.minTime, key.timestamp);
            this.maxTime = Math.max(this.maxTime, key.timestamp);
            this.facts.add(key);
            return -1;
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    static class CachingColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final HashMap<String, ColumnValueSelector<?>> columnSelectorMap;
        private final ColumnSelectorFactory delegate;

        public CachingColumnSelectorFactory(ColumnSelectorFactory delegate) {
            this.delegate = delegate;
            this.columnSelectorMap = new HashMap();
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.delegate.makeDimensionSelector(dimensionSpec);
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            ColumnValueSelector existing = this.columnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            ColumnValueSelector columnValueSelector = this.delegate.makeColumnValueSelector(columnName);
            existing = this.columnSelectorMap.putIfAbsent(columnName, columnValueSelector);
            return existing != null ? existing : columnValueSelector;
        }

        @Override
        @Nullable
        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return this.delegate.getColumnCapabilities(columnName);
        }
    }

    public static class Spec
    implements AppendableIndexSpec {
        private static final boolean DEFAULT_PRESERVE_EXISTING_METRICS = false;
        public static final String TYPE = "onheap";
        final boolean preserveExistingMetrics;

        public Spec() {
            this.preserveExistingMetrics = false;
        }

        @JsonCreator
        public Spec(@JsonProperty(value="preserveExistingMetrics") @Nullable Boolean preserveExistingMetrics) {
            this.preserveExistingMetrics = preserveExistingMetrics != null ? preserveExistingMetrics : false;
        }

        @JsonProperty
        public boolean isPreserveExistingMetrics() {
            return this.preserveExistingMetrics;
        }

        @Override
        public AppendableIndexBuilder builder() {
            return new Builder().setPreserveExistingMetrics(this.preserveExistingMetrics);
        }

        @Override
        public long getDefaultMaxBytesInMemory() {
            return JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes() / 6L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Spec spec = (Spec)o;
            return this.preserveExistingMetrics == spec.preserveExistingMetrics;
        }

        public int hashCode() {
            return Objects.hash(this.preserveExistingMetrics);
        }
    }

    public static class Builder
    extends AppendableIndexBuilder {
        @Override
        protected OnheapIncrementalIndex buildInner() {
            return new OnheapIncrementalIndex(Objects.requireNonNull(this.incrementalIndexSchema, "incrementIndexSchema is null"), this.maxRowCount, this.maxBytesInMemory, this.preserveExistingMetrics);
        }
    }
}

