/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class ByteBufferWriter<T>
implements Serializer {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final ObjectStrategy<T> strategy;
    @Nullable
    private WriteOutBytes headerOut = null;
    @Nullable
    private WriteOutBytes valueOut = null;

    public ByteBufferWriter(SegmentWriteOutMedium segmentWriteOutMedium, ObjectStrategy<T> strategy) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.strategy = strategy;
    }

    public void open() throws IOException {
        this.headerOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.valueOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    public void write(T objectToWrite) throws IOException {
        long sizeBefore = this.valueOut.size();
        this.strategy.writeTo(objectToWrite, this.valueOut);
        this.headerOut.writeInt(Ints.checkedCast((long)(this.valueOut.size() - sizeBefore)));
    }

    @Override
    public long getSerializedSize() {
        return this.headerOut.size() + this.valueOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        long numBytesWritten = this.headerOut.size() + this.valueOut.size();
        Preconditions.checkState((numBytesWritten < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Wrote[%s] bytes, which is too many.", (long)numBytesWritten);
        this.headerOut.writeTo(channel);
        this.valueOut.writeTo(channel);
    }
}

