/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerBase;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.TimeAndDimsIterator;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.file.SegmentFileBuilderV10;
import org.apache.druid.segment.file.SegmentFileChannel;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.projections.ProjectionMetadata;
import org.apache.druid.segment.serde.NullColumnPartSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMergerV10
extends IndexMergerBase {
    private static final Logger log = new Logger(IndexMergerV10.class);

    public IndexMergerV10(ObjectMapper mapper, IndexIO indexIO, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory) {
        super(mapper, indexIO, defaultSegmentWriteOutMediumFactory);
    }

    @Override
    protected boolean shouldStoreEmptyColumns() {
        return true;
    }

    @Override
    protected File makeIndexFiles(List<IndexableAdapter> adapters, @Nullable Metadata segmentMetadata, File outDir, ProgressIndicator progress, List<String> mergedDimensionsWithTime, IndexMergerBase.DimensionsSpecInspector dimensionsSpecInspector, List<String> mergedMetrics, Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        DruidException.conditionalDefensive(segmentMetadata != null, "Unexpected null Metadata when merging v10 segments", new Object[0]);
        String basePrefix = "__base/";
        progress.start();
        progress.progress();
        List<String> mergedDimensions = mergedDimensionsWithTime.stream().filter(dim -> !"__time".equals(dim)).collect(Collectors.toList());
        SegmentFileBuilderV10 v10Smoosher = SegmentFileBuilderV10.create(this.mapper, outDir, indexSpec.getMetadataCompression());
        try (Closer closer = Closer.create();){
            DateTime minTime = DateTimes.MAX;
            DateTime maxTime = DateTimes.MIN;
            for (IndexableAdapter index : adapters) {
                minTime = JodaUtils.minDateTime(minTime, index.getDataInterval().getStart());
                maxTime = JodaUtils.maxDateTime(maxTime, index.getDataInterval().getEnd());
            }
            Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
            v10Smoosher.addInterval(dataInterval.toString());
            v10Smoosher.addBitmapEncoding(indexSpec.getBitmapSerdeFactory());
            FileUtils.mkdirp(outDir);
            SegmentWriteOutMediumFactory omf = segmentWriteOutMediumFactory != null ? segmentWriteOutMediumFactory : this.defaultSegmentWriteOutMediumFactory;
            log.debug("Using SegmentWriteOutMediumFactory[%s]", omf.getClass().getSimpleName());
            SegmentWriteOutMedium segmentWriteOutMedium = omf.makeSegmentWriteOutMedium(outDir);
            closer.register(segmentWriteOutMedium);
            long startTime = System.currentTimeMillis();
            SegmentizerFactory customSegmentLoader = indexSpec.getSegmentLoader();
            if (customSegmentLoader != null) {
                try (FileOutputStream fos = new FileOutputStream(new File(outDir, "factory.json"));){
                    this.mapper.writeValue((OutputStream)fos, (Object)customSegmentLoader);
                    log.debug("Completed factory.json in %,d millis", System.currentTimeMillis() - startTime);
                }
            }
            progress.progress();
            TreeMap<String, ColumnFormat> metricFormats = new TreeMap<String, ColumnFormat>((Comparator<String>)Comparators.naturalNullsFirst());
            ArrayList dimFormats = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            this.mergeFormat(adapters, mergedDimensions, metricFormats, dimFormats);
            Map<String, DimensionHandler> handlers = this.makeDimensionHandlers(mergedDimensions, dimFormats);
            HashMap mergersMap = Maps.newHashMapWithExpectedSize((int)mergedDimensions.size());
            ArrayList<DimensionMergerV9> mergers = new ArrayList<DimensionMergerV9>();
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionHandler handler = handlers.get(mergedDimensions.get(i));
                DimensionMergerV9 merger = handler.makeMerger("__base/" + mergedDimensions.get(i), indexSpec, segmentWriteOutMedium, ((ColumnFormat)dimFormats.get(i)).toColumnCapabilities(), progress, outDir, closer);
                mergers.add(merger);
                mergersMap.put(mergedDimensions.get(i), merger);
            }
            if (segmentMetadata.getProjections() != null) {
                for (AggregateProjectionMetadata projectionMetadata : segmentMetadata.getProjections()) {
                    for (String dimension : projectionMetadata.getSchema().getGroupingColumns()) {
                        DimensionMergerV9 merger = (DimensionMergerV9)mergersMap.get(dimension);
                        if (merger == null) continue;
                        merger.markAsParent();
                    }
                }
            }
            progress.progress();
            startTime = System.currentTimeMillis();
            this.writeDimValuesAndSetupDimConversion(adapters, progress, mergedDimensions, mergers);
            log.debug("Completed dim conversions in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            TimeAndDimsIterator timeAndDimsIterator = this.makeMergedTimeAndDimsIterator(adapters, mergedDimensionsWithTime, mergedMetrics, rowMergerFn, handlers, mergers);
            closer.register(timeAndDimsIterator);
            GenericColumnSerializer timeWriter = this.setupTimeWriter(segmentWriteOutMedium, indexSpec);
            ArrayList<GenericColumnSerializer> metricWriters = this.setupMetricsWriters(segmentWriteOutMedium, mergedMetrics, metricFormats, indexSpec, "__base/");
            IndexMergerBase.IndexMergeResult indexMergeResult = this.mergeIndexesAndWriteColumns(adapters, progress, timeAndDimsIterator, timeWriter, metricWriters, mergers);
            String section = "build inverted index and columns";
            progress.startSection("build inverted index and columns");
            this.makeTimeColumn(v10Smoosher, progress, timeWriter, indexSpec, "__base/__time");
            this.makeMetricsColumns(v10Smoosher, progress, mergedMetrics, metricFormats, metricWriters, indexSpec, "__base/");
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                ColumnDescriptor columnDesc;
                DimensionMergerV9 merger = (DimensionMergerV9)mergers.get(i);
                merger.writeIndexes(indexMergeResult.rowNumConversions);
                if (!merger.hasOnlyNulls()) {
                    columnDesc = merger.makeColumnDescriptor();
                    this.makeColumn(v10Smoosher, "__base/" + mergedDimensions.get(i), columnDesc);
                    continue;
                }
                columnDesc = ColumnDescriptor.builder().setValueType((ValueType)((ColumnFormat)dimFormats.get(i)).getLogicalType().getType()).addSerde(new NullColumnPartSerde(indexMergeResult.rowCount, indexSpec.getBitmapSerdeFactory())).build();
                this.makeColumn(v10Smoosher, "__base/" + mergedDimensions.get(i), columnDesc);
            }
            progress.stopSection("build inverted index and columns");
            ArrayList<ProjectionMetadata> projections = new ArrayList<ProjectionMetadata>();
            projections.add(ProjectionMetadata.forBaseTable(indexMergeResult.rowCount, mergedDimensionsWithTime, segmentMetadata));
            if (!CollectionUtils.isNullOrEmpty(segmentMetadata.getProjections())) {
                Metadata updatedMetadata = this.makeProjections(v10Smoosher, segmentMetadata.getProjections(), adapters, indexSpec, segmentWriteOutMedium, progress, outDir, closer, mergersMap, segmentMetadata);
                for (AggregateProjectionMetadata aggMeta : updatedMetadata.getProjections()) {
                    projections.add(new ProjectionMetadata(aggMeta.getNumRows(), aggMeta.getSchema()));
                }
            }
            v10Smoosher.addProjections(projections);
            progress.progress();
            v10Smoosher.close();
            progress.stop();
            File file = outDir;
            return file;
        }
    }

    @Override
    protected void makeColumn(SegmentFileBuilder segmentFileBuilder, String columnName, ColumnDescriptor serdeficator) throws IOException {
        segmentFileBuilder.addColumn(columnName, serdeficator);
        try (SegmentFileChannel channel = segmentFileBuilder.addWithChannel(columnName, serdeficator.getSerializedSize());){
            serdeficator.writeTo(channel, segmentFileBuilder);
        }
    }
}

