/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.first;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.firstlast.first.NumericFirstBufferAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;

public class FloatFirstBufferAggregator
extends NumericFirstBufferAggregator {
    public FloatFirstBufferAggregator(BaseLongColumnValueSelector timeSelector, ColumnValueSelector valueSelector, boolean needsFoldCheck) {
        super(timeSelector, valueSelector, needsFoldCheck);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putFloat(position, 0.0f);
    }

    @Override
    void putValue(ByteBuffer buf, int position, ColumnValueSelector valueSector) {
        buf.putFloat(position, valueSector.getFloat());
    }

    @Override
    void putValue(ByteBuffer buf, int position, Number value) {
        buf.putFloat(position, value.floatValue());
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePairLongFloat(buf.getLong(position), rhsNull ? null : Float.valueOf(buf.getFloat(position + 9)));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getFloat(position + 9);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getFloat(position + 9);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getFloat(position + 9);
    }
}

