/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.SQLInputSourceDatabaseConnector;
import org.apache.druid.server.initialization.JdbcAccessSecurityConfig;
import org.apache.druid.utils.ConnectionUriUtils;
import org.skife.jdbi.v2.DBI;

@JsonTypeName(value="postgresql")
public class PostgresqlInputSourceDatabaseConnector
extends SQLInputSourceDatabaseConnector {
    private final DBI dbi;
    private final MetadataStorageConnectorConfig connectorConfig;

    @JsonCreator
    public PostgresqlInputSourceDatabaseConnector(@JsonProperty(value="connectorConfig") MetadataStorageConnectorConfig connectorConfig, @JacksonInject JdbcAccessSecurityConfig securityConfig) {
        this.connectorConfig = connectorConfig;
        BasicDataSource datasource = this.getDatasource(connectorConfig, securityConfig);
        datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        datasource.setDriverClassName("org.postgresql.Driver");
        this.dbi = new DBI((DataSource)datasource);
    }

    @JsonProperty
    public MetadataStorageConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public DBI getDBI() {
        return this.dbi;
    }

    public Set<String> findPropertyKeysFromConnectURL(String connectUri, boolean allowUnknown) {
        return ConnectionUriUtils.tryParseJdbcUriParameters((String)connectUri, (boolean)allowUnknown);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PostgresqlInputSourceDatabaseConnector that = (PostgresqlInputSourceDatabaseConnector)((Object)o);
        return this.connectorConfig.equals((Object)that.connectorConfig);
    }

    public int hashCode() {
        return Objects.hash(this.connectorConfig);
    }

    public String toString() {
        return "PostgresqlInputSourceDatabaseConnector{connectorConfig=" + String.valueOf(this.connectorConfig) + "}";
    }
}

