/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.key.ClusterByPartition;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.indexing.error.InsertTimeNullFault;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.TooManyPartitionsFault;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.kernel.GlobalSortShuffleSpec;
import org.apache.druid.msq.kernel.ShuffleKind;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.msq.kernel.controller.ControllerStagePhase;
import org.apache.druid.msq.kernel.controller.ControllerWorkerStagePhase;
import org.apache.druid.msq.kernel.controller.WorkerInputs;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.msq.statistics.CompleteKeyStatisticsInformation;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;

class ControllerStageTracker {
    private static final Logger log = new Logger(ControllerStageTracker.class);
    private static final long STATIC_TIME_CHUNK_FOR_PARALLEL_MERGE = Granularities.ALL.bucketStart(-1L);
    private final StageDefinition stageDef;
    private final int workerCount;
    private final WorkerInputs workerInputs;
    private final FrameType rowBasedFrameType;
    private final int maxPartitions;
    private final Int2ObjectMap<ControllerWorkerStagePhase> workerToPhase = new Int2ObjectOpenHashMap();
    private final IntSet workerReportedPartialKeyInformation = new IntAVLTreeSet();
    private final IntSet workersFromWhichKeyCollectorFetched = new IntAVLTreeSet();
    private final int maxRetainedPartitionSketchBytes;
    private ControllerStagePhase phase = ControllerStagePhase.NEW;
    @Nullable
    public final CompleteKeyStatisticsInformation completeKeyStatisticsInformation;
    @Nullable
    private ReadablePartitions resultPartitions;
    @Nullable
    private ClusterByPartitions resultPartitionBoundaries;
    private final Map<Long, ClusterByStatisticsCollector> timeChunkToCollector = new HashMap<Long, ClusterByStatisticsCollector>();
    private final Map<Long, ClusterByPartitions> timeChunkToBoundaries = new TreeMap<Long, ClusterByPartitions>();
    long totalPartitionCount;
    private Map<Integer, Set<Long>> workerToRemainingTimeChunks = null;
    private Map<Long, Set<Integer>> timeChunkToRemainingWorkers = null;
    @Nullable
    private Object resultObject;
    @Nullable
    private MSQFault failureReason;

    private ControllerStageTracker(StageDefinition stageDef, WorkerInputs workerInputs, FrameType rowBasedFrameType, int maxRetainedPartitionSketchBytes, int maxPartitions) {
        this.stageDef = stageDef;
        this.workerCount = workerInputs.workerCount();
        this.workerInputs = workerInputs;
        this.rowBasedFrameType = rowBasedFrameType;
        this.maxRetainedPartitionSketchBytes = maxRetainedPartitionSketchBytes;
        this.maxPartitions = maxPartitions;
        this.initializeWorkerState((IntSet)workerInputs.workers());
        if (stageDef.mustGatherResultKeyStatistics()) {
            this.completeKeyStatisticsInformation = new CompleteKeyStatisticsInformation(new TreeMap<Long, Set<Integer>>(), false, 0.0);
        } else {
            this.completeKeyStatisticsInformation = null;
            this.generateResultPartitionsAndBoundariesWithoutKeyStatistics();
        }
    }

    private void initializeWorkerState(IntSet workers) {
        IntIterator intIterator = workers.iterator();
        while (intIterator.hasNext()) {
            int workerNumber = (Integer)intIterator.next();
            this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.NEW);
        }
    }

    static ControllerStageTracker create(StageDefinition stageDef, Int2IntMap stageWorkerCountMap, InputSpecSlicer slicer, WorkerAssignmentStrategy assignmentStrategy, FrameType rowBasedFrameType, int maxRetainedPartitionSketchBytes, int maxInputFilesPerWorker, long maxInputBytesPerWorker, int maxPartitions) {
        WorkerInputs workerInputs = WorkerInputs.create(stageDef, stageWorkerCountMap, slicer, assignmentStrategy, maxInputFilesPerWorker, maxInputBytesPerWorker);
        return new ControllerStageTracker(stageDef, workerInputs, rowBasedFrameType, maxRetainedPartitionSketchBytes, maxPartitions);
    }

    StageDefinition getStageDefinition() {
        return this.stageDef;
    }

    ControllerStagePhase getPhase() {
        return this.phase;
    }

    boolean hasResultPartitions() {
        return this.resultPartitions != null;
    }

    ReadablePartitions getResultPartitions() {
        if (this.resultPartitions == null) {
            throw new ISE("Result partition information is not ready yet", new Object[0]);
        }
        return this.resultPartitions;
    }

    ClusterByPartitions getResultPartitionBoundaries() {
        if (!this.getStageDefinition().doesShuffle()) {
            throw new ISE("Result partition information is not relevant to this stage because it does not shuffle", new Object[0]);
        }
        if (this.resultPartitionBoundaries == null) {
            throw new ISE("Result partition information is not ready yet", new Object[0]);
        }
        return this.resultPartitionBoundaries;
    }

    IntSet getWorkersToSendPartitionBoundaries() {
        if (!this.getStageDefinition().doesShuffle()) {
            throw new ISE("Result partition information is not relevant to this stage because it does not shuffle", new Object[0]);
        }
        IntAVLTreeSet workers = new IntAVLTreeSet();
        IntIterator intIterator = this.workerToPhase.keySet().iterator();
        while (intIterator.hasNext()) {
            int worker = (Integer)intIterator.next();
            if (!ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES.equals(this.workerToPhase.get(worker))) continue;
            workers.add(worker);
        }
        return workers;
    }

    void workOrderSentForWorker(int worker) {
        this.workerToPhase.compute(worker, (wk, state) -> {
            if (state == null) {
                throw new ISE("Worker[%d] not found for stage[%s]", new Object[]{wk, this.stageDef.getStageNumber()});
            }
            if (!ControllerWorkerStagePhase.READING_INPUT.canTransitionFrom((ControllerWorkerStagePhase)((Object)state))) {
                throw new ISE("Worker[%d] cannot transistion from state[%s] to state[%s] while sending work order", new Object[]{worker, state, ControllerWorkerStagePhase.READING_INPUT});
            }
            return ControllerWorkerStagePhase.READING_INPUT;
        });
        if (this.phase != ControllerStagePhase.READING_INPUT && this.allWorkOrdersSent()) {
            this.transitionTo(ControllerStagePhase.READING_INPUT);
        }
    }

    void partitionBoundariesSentForWorker(int worker) {
        this.workerToPhase.compute(worker, (wk, state) -> {
            if (state == null) {
                throw new ISE("Worker[%d] not found for stage[%s]", new Object[]{wk, this.stageDef.getStageNumber()});
            }
            if (!ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT.canTransitionFrom((ControllerWorkerStagePhase)((Object)state))) {
                throw new ISE("Worker[%d] cannot transistion from state[%s] to state[%s] while sending partition boundaries", new Object[]{worker, state, ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT});
            }
            return ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT;
        });
    }

    boolean collectorEncounteredAnyMultiValueField() {
        if (this.completeKeyStatisticsInformation == null) {
            throw new ISE("Stage does not gather result key statistics", new Object[0]);
        }
        if (this.workerReportedPartialKeyInformation.size() != this.workerCount) {
            throw new ISE("Result key statistics are not ready", new Object[0]);
        }
        return this.completeKeyStatisticsInformation.hasMultipleValues();
    }

    Object getResultObject() {
        if (!this.phase.isSuccess()) {
            throw new ISE("Result object for stage[%s] is not ready yet", new Object[]{this.stageDef.getId()});
        }
        if (this.resultObject == null) {
            throw new NullPointerException(StringUtils.format((String)"Result object for stage[%s] was unexpectedly null", (Object[])new Object[]{this.stageDef.getId()}));
        }
        return this.resultObject;
    }

    void start() {
        this.transitionTo(ControllerStagePhase.READING_INPUT);
    }

    void finish() {
        this.transitionTo(ControllerStagePhase.FINISHED);
    }

    WorkerInputs getWorkerInputs() {
        return this.workerInputs;
    }

    @Nullable
    public CompleteKeyStatisticsInformation getCompleteKeyStatisticsInformation() {
        return this.completeKeyStatisticsInformation;
    }

    void addPartialKeyInformationForWorker(int workerNumber, PartialKeyStatisticsInformation partialKeyStatisticsInformation) {
        block14: {
            if (!this.stageDef.mustGatherResultKeyStatistics() || !this.stageDef.doesShuffle() || this.completeKeyStatisticsInformation == null) {
                throw new ISE("Stage does not gather result key statistics", new Object[0]);
            }
            if (!this.workerInputs.workers().contains(workerNumber)) {
                throw new IAE("Invalid workerNumber [%s]", new Object[]{workerNumber});
            }
            ControllerWorkerStagePhase currentPhase = (ControllerWorkerStagePhase)((Object)this.workerToPhase.get(workerNumber));
            if (currentPhase == null) {
                throw new ISE("Worker[%d] not found for stage[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber()});
            }
            try {
                if (ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_ALL_KEY_STATS_TO_BE_FETCHED.canTransitionFrom(currentPhase)) {
                    this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_ALL_KEY_STATS_TO_BE_FETCHED);
                    if (this.workerReportedPartialKeyInformation.add(workerNumber)) {
                        if (partialKeyStatisticsInformation.getTimeSegments().contains(null)) {
                            this.failForReason(InsertTimeNullFault.instance());
                            return;
                        }
                        this.completeKeyStatisticsInformation.mergePartialInformation(workerNumber, partialKeyStatisticsInformation);
                    }
                    if (this.resultPartitions != null) {
                        this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES);
                    }
                    if (this.workersFromWhichKeyCollectorFetched.contains(workerNumber)) {
                        this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES);
                    }
                    if (this.allPartialKeyInformationFetched()) {
                        this.completeKeyStatisticsInformation.complete();
                        if (this.workerToRemainingTimeChunks == null && this.timeChunkToRemainingWorkers == null) {
                            this.initializeTimeChunkWorkerTrackers();
                        }
                        if (this.phase != ControllerStagePhase.FAILED) {
                            this.transitionTo(ControllerStagePhase.MERGING_STATISTICS);
                        }
                        if (this.allResultsStatsFetched() && this.phase != ControllerStagePhase.FAILED) {
                            this.transitionTo(ControllerStagePhase.POST_READING);
                        }
                    }
                    break block14;
                }
                throw new ISE("Worker[%d] for stage[%d] expected to be in state[%s]. Found state[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber(), ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_ALL_KEY_STATS_TO_BE_FETCHED, currentPhase});
            }
            catch (Exception e) {
                this.fail();
                throw e;
            }
        }
    }

    private void initializeTimeChunkWorkerTrackers() {
        this.workerToRemainingTimeChunks = new HashMap<Integer, Set<Long>>();
        this.timeChunkToRemainingWorkers = new HashMap<Long, Set<Integer>>();
        this.completeKeyStatisticsInformation.getTimeSegmentVsWorkerMap().forEach((timeChunk, workers) -> {
            Iterator iterator = workers.iterator();
            while (iterator.hasNext()) {
                int worker = (Integer)iterator.next();
                this.workerToRemainingTimeChunks.compute(worker, (wk, timeChunks) -> {
                    if (timeChunks == null) {
                        timeChunks = new HashSet<Long>();
                    }
                    timeChunks.add(timeChunk);
                    return timeChunks;
                });
            }
            this.timeChunkToRemainingWorkers.put((Long)timeChunk, (Set<Integer>)workers);
        });
    }

    void mergeClusterByStatisticsCollectorForTimeChunk(int workerNumber, Long timeChunk, ClusterByStatisticsSnapshot clusterByStatisticsSnapshot) {
        if (!this.stageDef.mustGatherResultKeyStatistics() || !this.stageDef.doesShuffle()) {
            throw new ISE("Stage does not gather result key statistics", new Object[0]);
        }
        if (!this.workerInputs.workers().contains(workerNumber)) {
            throw new IAE("Invalid workerNumber [%s]", new Object[]{workerNumber});
        }
        if (this.completeKeyStatisticsInformation == null || !this.completeKeyStatisticsInformation.isComplete()) {
            throw new ISE("Cannot merge worker[%d] time chunk until all the key information is received for stage[%d]", new Object[]{workerNumber, this.stageDef.getStageNumber()});
        }
        ControllerWorkerStagePhase workerStagePhase = (ControllerWorkerStagePhase)((Object)this.workerToPhase.get(workerNumber));
        if (workerStagePhase == null) {
            throw new ISE("Worker[%d] not found for stage[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber()});
        }
        this.workerToRemainingTimeChunks.computeIfPresent(workerNumber, (wk, timeChunks) -> {
            if (timeChunks.remove(timeChunk)) {
                this.timeChunkToCollector.compute(timeChunk, (ignored, collector) -> {
                    if (collector == null) {
                        collector = this.stageDef.createResultKeyStatisticsCollector(this.rowBasedFrameType, this.maxRetainedPartitionSketchBytes);
                    }
                    collector.addAll(clusterByStatisticsSnapshot);
                    return collector;
                });
                this.timeChunkToRemainingWorkers.compute(timeChunk, (tc, workers) -> {
                    if (workers == null || workers.isEmpty()) {
                        throw new ISE("Remaining workers should not be empty until all the work is finished for time chunk[%d] for stage[%d]", new Object[]{timeChunk, this.stageDef.getStageNumber()});
                    }
                    workers.remove(workerNumber);
                    if (workers.isEmpty()) {
                        log.info("Generating partition boundaries from stage: %d of time chunk: [%s] GMT", new Object[]{this.stageDef.getStageNumber(), new Date(timeChunk)});
                        ClusterByStatisticsCollector collector = this.timeChunkToCollector.get(tc);
                        Either<Long, ClusterByPartitions> countOrPartitions = this.stageDef.generatePartitionBoundariesForShuffle(collector, this.maxPartitions);
                        this.totalPartitionCount += ControllerStageTracker.getPartitionCountFromEither(countOrPartitions);
                        if (this.totalPartitionCount > (long)this.maxPartitions) {
                            this.failForReason(new TooManyPartitionsFault(this.maxPartitions));
                            return null;
                        }
                        this.timeChunkToBoundaries.put((Long)tc, (ClusterByPartitions)countOrPartitions.valueOrThrow());
                        collector.clear();
                        this.timeChunkToCollector.remove(tc);
                        return null;
                    }
                    return workers;
                });
            }
            return timeChunks.isEmpty() ? null : timeChunks;
        });
        if (this.workerToRemainingTimeChunks.get(workerNumber) == null) {
            this.workersFromWhichKeyCollectorFetched.add(workerNumber);
            if (ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES.canTransitionFrom(workerStagePhase)) {
                this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES);
            } else {
                throw new ISE("Worker[%d] for stage[%d] expected to be in state[%s]. Found state[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber(), ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES, workerStagePhase});
            }
        }
        if (this.workerToRemainingTimeChunks.isEmpty()) {
            if (this.resultPartitionBoundaries == null) {
                this.timeChunkToBoundaries.forEach((ignored, partitions) -> {
                    if (this.resultPartitionBoundaries == null) {
                        this.resultPartitionBoundaries = partitions;
                    } else {
                        this.abutAndAppendPartitionBoundaries(this.resultPartitionBoundaries.ranges(), partitions.ranges());
                    }
                });
                this.timeChunkToBoundaries.clear();
                this.setClusterByPartitionBoundaries(this.resultPartitionBoundaries);
            } else {
                this.transitionTo(ControllerStagePhase.POST_READING);
            }
        }
    }

    void mergeClusterByStatisticsCollectorForAllTimeChunks(int workerNumber, ClusterByStatisticsSnapshot clusterByStatsSnapshot) {
        if (!this.stageDef.mustGatherResultKeyStatistics() || !this.stageDef.doesShuffle()) {
            throw new ISE("Stage does not gather result key statistics", new Object[0]);
        }
        if (!this.workerInputs.workers().contains(workerNumber)) {
            throw new IAE("Invalid workerNumber [%s]", new Object[]{workerNumber});
        }
        ControllerWorkerStagePhase workerStagePhase = (ControllerWorkerStagePhase)((Object)this.workerToPhase.get(workerNumber));
        if (workerStagePhase == null) {
            throw new ISE("Worker[%d] not found for stage[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber()});
        }
        if (this.workersFromWhichKeyCollectorFetched.add(workerNumber)) {
            this.timeChunkToCollector.compute(STATIC_TIME_CHUNK_FOR_PARALLEL_MERGE, (timeChunk, stats) -> {
                if (stats == null) {
                    stats = this.stageDef.createResultKeyStatisticsCollector(this.rowBasedFrameType, this.maxRetainedPartitionSketchBytes);
                }
                stats.addAll(clusterByStatsSnapshot);
                return stats;
            });
        } else {
            log.debug("Already have key collector for worker[%d] stage[%d]", new Object[]{workerNumber, this.stageDef.getStageNumber()});
        }
        if (!ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES.canTransitionFrom(workerStagePhase)) {
            throw new ISE("Worker[%d] for stage[%d] expected to be in state[%s]. Found state[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber(), ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES, workerStagePhase});
        }
        this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES);
        if (this.allResultsStatsFetched()) {
            if (this.completeKeyStatisticsInformation == null || !this.completeKeyStatisticsInformation.isComplete()) {
                throw new ISE("Cannot generate partition boundaries until all the key information is received for worker[%d] stage[%d]", new Object[]{workerNumber, this.stageDef.getStageNumber()});
            }
            if (this.resultPartitions == null) {
                ClusterByStatisticsCollector collector2 = this.timeChunkToCollector.get(STATIC_TIME_CHUNK_FOR_PARALLEL_MERGE);
                Either<Long, ClusterByPartitions> countOrPartitions = this.stageDef.generatePartitionBoundariesForShuffle(collector2, this.maxPartitions);
                this.totalPartitionCount += ControllerStageTracker.getPartitionCountFromEither(countOrPartitions);
                if (this.totalPartitionCount > (long)this.maxPartitions) {
                    this.failForReason(new TooManyPartitionsFault(this.maxPartitions));
                    return;
                }
                this.resultPartitionBoundaries = (ClusterByPartitions)countOrPartitions.valueOrThrow();
                this.setClusterByPartitionBoundaries(this.resultPartitionBoundaries);
            } else {
                log.debug("Already have result partitions for stage[%d]", new Object[]{this.stageDef.getStageNumber()});
            }
            this.timeChunkToCollector.computeIfPresent(STATIC_TIME_CHUNK_FOR_PARALLEL_MERGE, (key, collector) -> collector.clear());
            this.timeChunkToCollector.clear();
        }
    }

    private boolean allResultsStatsFetched() {
        return this.workerToPhase.values().stream().filter(stagePhase -> stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES) || stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT) || stagePhase.equals((Object)ControllerWorkerStagePhase.RESULTS_READY)).count() == (long)this.workerCount;
    }

    void setClusterByPartitionBoundaries(ClusterByPartitions clusterByPartitions) {
        if (this.resultPartitions != null) {
            throw new ISE("Result partitions have already been generated", new Object[0]);
        }
        if (!this.stageDef.mustGatherResultKeyStatistics()) {
            throw new ISE("Result partitions does not require key statistics, should not have set partition boundries here", new Object[0]);
        }
        if (!ControllerStagePhase.MERGING_STATISTICS.equals((Object)this.getPhase())) {
            throw new ISE("Cannot set partition boundaries from key statistics from stage [%s]", new Object[]{this.getPhase()});
        }
        this.resultPartitionBoundaries = clusterByPartitions;
        this.resultPartitions = ReadablePartitions.striped(this.stageDef.getStageNumber(), this.workerInputs.workers(), clusterByPartitions.size());
        this.transitionTo(ControllerStagePhase.POST_READING);
    }

    void setDoneReadingInputForWorker(int workerNumber) {
        block8: {
            if (this.stageDef.mustGatherResultKeyStatistics()) {
                throw DruidException.defensive((String)"Cannot setDoneReadingInput for stage[%s], it should send partial key information instead", (Object[])new Object[]{this.stageDef.getId()});
            }
            if (!this.stageDef.doesSortDuringShuffle()) {
                throw DruidException.defensive((String)"Cannot setDoneReadingInput for stage[%s], it is not sorting", (Object[])new Object[]{this.stageDef.getId()});
            }
            if (!this.workerInputs.workers().contains(workerNumber)) {
                throw new IAE("Invalid workerNumber[%s] for stage[%s]", new Object[]{workerNumber, this.stageDef.getId()});
            }
            ControllerWorkerStagePhase currentPhase = (ControllerWorkerStagePhase)((Object)this.workerToPhase.get(workerNumber));
            if (currentPhase == null) {
                throw new ISE("Worker[%d] not found for stage[%s]", new Object[]{workerNumber, this.stageDef.getId()});
            }
            try {
                if (ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT.canTransitionFrom(currentPhase)) {
                    this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT);
                    if (this.allWorkersDoneReadingInput()) {
                        this.transitionTo(ControllerStagePhase.POST_READING);
                    }
                    break block8;
                }
                throw new ISE("Worker[%d] for stage[%d] expected to be in phase that can transition to[%s]. Found phase[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber(), ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT, currentPhase});
            }
            catch (Exception e) {
                this.fail();
                throw e;
            }
        }
    }

    boolean setResultsCompleteForWorker(int workerNumber, Object resultObject) {
        if (!this.workerInputs.workers().contains(workerNumber)) {
            throw new IAE("Invalid workerNumber [%s]", new Object[]{workerNumber});
        }
        if (resultObject == null) {
            throw new NullPointerException("resultObject must not be null");
        }
        ControllerWorkerStagePhase currentPhase = (ControllerWorkerStagePhase)((Object)this.workerToPhase.get(workerNumber));
        if (currentPhase == null) {
            throw new ISE("Worker[%d] not found for stage[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber()});
        }
        if (ControllerWorkerStagePhase.RESULTS_READY.canTransitionFrom(currentPhase)) {
            if (this.stageDef.mustGatherResultKeyStatistics() && currentPhase == ControllerWorkerStagePhase.READING_INPUT) {
                throw new ISE("Worker[%d] for stage[%d] expected to be in state[%s]. Found state[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber(), ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT, currentPhase});
            }
            this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.RESULTS_READY);
            this.resultObject = this.resultObject == null ? resultObject : this.getStageDefinition().getProcessor().mergeAccumulatedResult(this.resultObject, resultObject);
        } else {
            throw new ISE("Worker[%d] for stage[%d] expected to be in state[%s]. Found state[%s]", new Object[]{workerNumber, this.stageDef.getStageNumber(), this.stageDef.mustGatherResultKeyStatistics() ? ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT : ControllerWorkerStagePhase.READING_INPUT, currentPhase});
        }
        if (this.allResultsPresent()) {
            this.transitionTo(ControllerStagePhase.RESULTS_READY);
            return true;
        }
        return false;
    }

    private boolean allResultsPresent() {
        return this.workerToPhase.values().stream().filter(stagePhase -> stagePhase.equals((Object)ControllerWorkerStagePhase.RESULTS_READY)).count() == (long)this.workerCount;
    }

    MSQFault getFailureReason() {
        if (this.phase != ControllerStagePhase.FAILED) {
            throw new ISE("No failure", new Object[0]);
        }
        return this.failureReason;
    }

    void fail() {
        this.failForReason(UnknownFault.forMessage(null));
    }

    private void generateResultPartitionsAndBoundariesWithoutKeyStatistics() {
        if (this.resultPartitions != null) {
            log.debug("Partition boundaries already generated for stage %d", new Object[]{this.stageDef.getStageNumber()});
            return;
        }
        int stageNumber = this.stageDef.getStageNumber();
        if (this.stageDef.doesShuffle()) {
            ShuffleSpec shuffleSpec = this.stageDef.getShuffleSpec();
            if (shuffleSpec.kind() == ShuffleKind.GLOBAL_SORT) {
                if (((GlobalSortShuffleSpec)shuffleSpec).mustGatherResultKeyStatistics() && !this.allPartialKeyInformationFetched()) {
                    throw new ISE("Cannot generate result partitions without all worker key statistics", new Object[0]);
                }
                Either<Long, ClusterByPartitions> maybeResultPartitionBoundaries = this.stageDef.generatePartitionBoundariesForShuffle(null, this.maxPartitions);
                if (maybeResultPartitionBoundaries.isError()) {
                    this.failForReason(new TooManyPartitionsFault(this.maxPartitions));
                    return;
                }
                this.resultPartitionBoundaries = (ClusterByPartitions)maybeResultPartitionBoundaries.valueOrThrow();
                this.resultPartitions = ReadablePartitions.striped(stageNumber, this.workerInputs.workers(), this.resultPartitionBoundaries.size());
            } else {
                if (shuffleSpec.kind() == ShuffleKind.MIX) {
                    this.resultPartitionBoundaries = ClusterByPartitions.oneUniversalPartition();
                }
                this.resultPartitions = ReadablePartitions.striped(stageNumber, this.workerInputs.workers(), shuffleSpec.partitionCount());
            }
        } else {
            Int2IntAVLTreeMap partitionToWorkerMap = new Int2IntAVLTreeMap();
            IntBidirectionalIterator intBidirectionalIterator = this.workerInputs.workers().iterator();
            while (intBidirectionalIterator.hasNext()) {
                int workerNumber = (Integer)intBidirectionalIterator.next();
                List<InputSlice> slices = this.workerInputs.inputsForWorker(workerNumber);
                for (int inputNumber = 0; inputNumber < slices.size(); ++inputNumber) {
                    InputSlice slice = slices.get(inputNumber);
                    if (!(slice instanceof StageInputSlice) || this.stageDef.getBroadcastInputNumbers().contains(inputNumber)) continue;
                    StageInputSlice stageInputSlice = (StageInputSlice)slice;
                    for (ReadablePartition partition : stageInputSlice.getPartitions()) {
                        partitionToWorkerMap.put(partition.getPartitionNumber(), workerNumber);
                    }
                }
            }
            this.resultPartitions = ReadablePartitions.collected(stageNumber, (Map<Integer, Integer>)partitionToWorkerMap);
        }
    }

    public boolean allPartialKeyInformationFetched() {
        if (!this.stageDef.mustGatherResultKeyStatistics()) {
            return true;
        }
        return this.workerToPhase.values().stream().filter(stagePhase -> stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_ALL_KEY_STATS_TO_BE_FETCHED) || stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_FETCHING_ALL_KEY_STATS) || stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES) || stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT) || stagePhase.equals((Object)ControllerWorkerStagePhase.RESULTS_READY)).count() == (long)this.workerCount;
    }

    public boolean allWorkersDoneReadingInput() {
        for (ControllerWorkerStagePhase phase : this.workerToPhase.values()) {
            if (phase == ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT || phase == ControllerWorkerStagePhase.RESULTS_READY) continue;
            return false;
        }
        return true;
    }

    private boolean allWorkOrdersSent() {
        return this.workerToPhase.values().stream().filter(stagePhase -> stagePhase.equals((Object)ControllerWorkerStagePhase.READING_INPUT) || stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_ALL_KEY_STATS_TO_BE_FETCHED) || stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_FETCHING_ALL_KEY_STATS) || stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES) || stagePhase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT) || stagePhase.equals((Object)ControllerWorkerStagePhase.RESULTS_READY)).count() == (long)this.workerCount;
    }

    void failForReason(MSQFault fault) {
        this.transitionTo(ControllerStagePhase.FAILED);
        this.failureReason = fault;
    }

    private void transitionTo(ControllerStagePhase newPhase) {
        if (!newPhase.canTransitionFrom(this.phase)) {
            throw new IAE("Cannot transition stage[%s] from[%s] to[%s]", new Object[]{this.stageDef.getId(), this.phase, newPhase});
        }
        this.phase = newPhase;
    }

    public boolean retryIfNeeded(int workerNumber) {
        if (this.phase.equals((Object)ControllerStagePhase.FINISHED) || this.phase.equals((Object)ControllerStagePhase.RESULTS_READY)) {
            return false;
        }
        if (!this.isTrackingWorker(workerNumber)) {
            return false;
        }
        if (((ControllerWorkerStagePhase)((Object)this.workerToPhase.get(workerNumber))).equals((Object)ControllerWorkerStagePhase.RESULTS_READY) || ((ControllerWorkerStagePhase)((Object)this.workerToPhase.get(workerNumber))).equals((Object)ControllerWorkerStagePhase.FINISHED)) {
            return false;
        }
        this.workerToPhase.put(workerNumber, (Object)ControllerWorkerStagePhase.NEW);
        this.transitionTo(ControllerStagePhase.RETRYING);
        return true;
    }

    private boolean isTrackingWorker(int workerNumber) {
        return this.workerToPhase.get(workerNumber) != null;
    }

    public Set<Integer> getWorkersToFetchClusterStatisticsFrom() {
        HashSet<Integer> workersToFetchStats = new HashSet<Integer>();
        this.workerToPhase.forEach((worker, phase) -> {
            if (phase.equals((Object)ControllerWorkerStagePhase.PRESHUFFLE_WAITING_FOR_ALL_KEY_STATS_TO_BE_FETCHED)) {
                workersToFetchStats.add((Integer)worker);
            }
        });
        return workersToFetchStats;
    }

    public void startFetchingStatsFromWorker(int worker) {
        ControllerWorkerStagePhase workerStagePhase = (ControllerWorkerStagePhase)((Object)this.workerToPhase.get(worker));
        if (!ControllerWorkerStagePhase.PRESHUFFLE_FETCHING_ALL_KEY_STATS.canTransitionFrom(workerStagePhase)) {
            throw new ISE("Worker[%d] for stage[%d] expected to be in state[%s]. Found state[%s]", new Object[]{worker, this.stageDef.getStageNumber(), ControllerWorkerStagePhase.PRESHUFFLE_FETCHING_ALL_KEY_STATS, workerStagePhase});
        }
        this.workerToPhase.put(worker, (Object)ControllerWorkerStagePhase.PRESHUFFLE_FETCHING_ALL_KEY_STATS);
    }

    private void abutAndAppendPartitionBoundaries(List<ClusterByPartition> finalPartitionBoundaries, List<ClusterByPartition> timeSketchPartitions) {
        if (!finalPartitionBoundaries.isEmpty()) {
            ClusterByPartition clusterByPartition = finalPartitionBoundaries.remove(finalPartitionBoundaries.size() - 1);
            finalPartitionBoundaries.add(new ClusterByPartition(clusterByPartition.getStart(), timeSketchPartitions.get(0).getStart()));
        }
        finalPartitionBoundaries.addAll(timeSketchPartitions);
    }

    private static long getPartitionCountFromEither(Either<Long, ClusterByPartitions> either) {
        if (either.isError()) {
            return (Long)either.error();
        }
        return ((ClusterByPartitions)either.valueOrThrow()).size();
    }
}

