/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.msq.kernel.ShuffleKind;
import org.apache.druid.msq.kernel.ShuffleSpec;

public class HashShuffleSpec
implements ShuffleSpec {
    public static final String TYPE = "hash";
    private final ClusterBy clusterBy;
    private final int numPartitions;

    @JsonCreator
    public HashShuffleSpec(@JsonProperty(value="clusterBy") ClusterBy clusterBy, @JsonProperty(value="partitions") int numPartitions) {
        this.clusterBy = clusterBy;
        this.numPartitions = numPartitions;
        if (clusterBy.getBucketByCount() > 0) {
            throw new IAE("Cannot bucket with %s partitioning (clusterBy = %s)", new Object[]{TYPE, clusterBy});
        }
    }

    @Override
    public ShuffleKind kind() {
        return this.clusterBy.sortable() && !this.clusterBy.isEmpty() ? ShuffleKind.HASH_LOCAL_SORT : ShuffleKind.HASH;
    }

    @Override
    @JsonProperty
    public ClusterBy clusterBy() {
        return this.clusterBy;
    }

    @Override
    @JsonProperty(value="partitions")
    public int partitionCount() {
        return this.numPartitions;
    }
}

