/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.msq.statistics.serde.ClusterByStatisticsSnapshotSerde;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class SketchResponseHandler
implements HttpResponseHandler<BytesFullResponseHolder, ClusterByStatisticsSnapshot> {
    private final ObjectMapper jsonMapper;
    private Function<BytesFullResponseHolder, ClusterByStatisticsSnapshot> deserializerFunction;

    public SketchResponseHandler(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public ClientResponse<BytesFullResponseHolder> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
        BytesFullResponseHolder holder = new BytesFullResponseHolder(response);
        String contentType = response.headers().get("Content-Type");
        this.deserializerFunction = "application/octet-stream".equals(contentType) ? responseHolder -> ClusterByStatisticsSnapshotSerde.deserialize(ByteBuffer.wrap(responseHolder.getContent())) : responseHolder -> (ClusterByStatisticsSnapshot)responseHolder.deserialize(this.jsonMapper, (TypeReference)new TypeReference<ClusterByStatisticsSnapshot>(){});
        holder.addChunk(this.getContentBytes(response.getContent()));
        return ClientResponse.unfinished((Object)holder);
    }

    public ClientResponse<BytesFullResponseHolder> handleChunk(ClientResponse<BytesFullResponseHolder> response, HttpChunk chunk, long chunkNum) {
        BytesFullResponseHolder holder = (BytesFullResponseHolder)response.getObj();
        if (holder == null) {
            return ClientResponse.finished(null);
        }
        holder.addChunk(this.getContentBytes(chunk.getContent()));
        return response;
    }

    public ClientResponse<ClusterByStatisticsSnapshot> done(ClientResponse<BytesFullResponseHolder> response) {
        return ClientResponse.finished((Object)this.deserializerFunction.apply((BytesFullResponseHolder)response.getObj()));
    }

    public void exceptionCaught(ClientResponse<BytesFullResponseHolder> clientResponse, Throwable e) {
    }

    private byte[] getContentBytes(ChannelBuffer content) {
        byte[] contentBytes = new byte[content.readableBytes()];
        content.readBytes(contentBytes);
        return contentBytes;
    }
}

