/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.destination.DataSourceMSQDestination;
import org.apache.druid.msq.indexing.destination.ExportMSQDestination;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.QueryNotSupportedFault;
import org.apache.druid.msq.input.InputSpecs;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.msq.querykit.results.ExportResultsStageProcessor;
import org.apache.druid.msq.querykit.results.QueryResultStageProcessor;
import org.apache.druid.msq.util.MSQTaskQueryMakerUtils;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.storage.ExportStorageProvider;

public class QueryKitBasedMSQPlanner {
    private final MSQSpec querySpec;
    private final ResultsContext resultsContext;
    private final QueryKitSpec queryKitSpec;
    private final ObjectMapper jsonMapper;
    private final MSQTuningConfig tuningConfig;
    private final ColumnMappings columnMappings;
    private final MSQDestination destination;
    private final QueryContext queryContext;
    private final Query<?> query;

    public QueryKitBasedMSQPlanner(MSQSpec querySpec, ResultsContext resultsContext, Query<?> query, ObjectMapper jsonMapper, QueryKitSpec queryKitSpec) {
        this.querySpec = querySpec;
        this.jsonMapper = jsonMapper;
        this.tuningConfig = querySpec.getTuningConfig();
        this.columnMappings = querySpec.getColumnMappings();
        this.destination = querySpec.getDestination();
        this.queryContext = querySpec.getContext();
        this.query = query;
        this.resultsContext = resultsContext;
        this.queryKitSpec = queryKitSpec;
    }

    public QueryDefinition makeQueryDefinition() {
        Query queryToPlan;
        if (MSQControllerTask.isIngestion(this.destination)) {
            if (!this.columnMappings.hasUniqueOutputColumnNames()) {
                throw new ISE("Column names are not unique: [%s]", new Object[]{this.columnMappings.getOutputColumnNames()});
            }
            MSQTaskQueryMakerUtils.validateRealtimeReindex(this.queryContext, this.destination, this.query);
            if (this.columnMappings.hasOutputColumn("__time")) {
                int timeColumn = this.columnMappings.getOutputColumnsByName("__time").getInt(0);
                queryToPlan = this.query.withOverriddenContext((Map)ImmutableMap.of((Object)"__timeColumn", (Object)this.columnMappings.getQueryColumnName(timeColumn)));
            } else {
                queryToPlan = this.query;
            }
        } else {
            queryToPlan = this.query;
        }
        return this.makeQueryDefinitionInternal(queryToPlan).withOverriddenContext(queryToPlan.getContext());
    }

    private QueryDefinition makeQueryDefinitionInternal(Query<?> queryToPlan) {
        QueryDefinition queryDef;
        try {
            queryDef = this.queryKitSpec.getQueryKit().makeQueryDefinition(this.queryKitSpec, QueryKitBasedMSQPlanner.propagateWindowOperatorTransformationContext(queryToPlan), this.makeResultShuffleSpecFacory(), 0);
        }
        catch (MSQException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MSQException(e, QueryNotSupportedFault.INSTANCE);
        }
        if (MSQControllerTask.isIngestion(this.destination)) {
            StageDefinition finalShuffleStageDef = queryDef.getFinalStageDefinition();
            while (!finalShuffleStageDef.doesShuffle() && InputSpecs.getStageNumbers(finalShuffleStageDef.getInputSpecs()).size() == 1) {
                finalShuffleStageDef = queryDef.getStageDefinition((Integer)Iterables.getOnlyElement((Iterable)InputSpecs.getStageNumbers(finalShuffleStageDef.getInputSpecs())));
            }
            if (!finalShuffleStageDef.doesShuffle()) {
                finalShuffleStageDef = null;
            }
            QueryDefinitionBuilder builder = QueryDefinition.builder(this.queryKitSpec.getQueryId());
            for (StageDefinition stageDef : queryDef.getStageDefinitions()) {
                if (stageDef.equals(finalShuffleStageDef)) {
                    builder.add(StageDefinition.builder(stageDef).shuffleCheckHasMultipleValues(true));
                    continue;
                }
                builder.add(StageDefinition.builder(stageDef));
            }
            DataSourceMSQDestination destination1 = (DataSourceMSQDestination)this.destination;
            return builder.add(destination1.getTerminalStageSpec().constructFinalStage(queryDef, this.querySpec, this.jsonMapper, this.query)).build();
        }
        if (MSQControllerTask.writeFinalResultsToTaskReport(this.destination)) {
            return queryDef;
        }
        if (MSQControllerTask.writeFinalStageResultsToDurableStorage(this.destination)) {
            StageDefinition finalShuffleStageDef = queryDef.getFinalStageDefinition();
            if (finalShuffleStageDef.doesSortDuringShuffle()) {
                QueryDefinitionBuilder builder = QueryDefinition.builder(this.queryKitSpec.getQueryId());
                builder.addAll(queryDef);
                builder.add(StageDefinition.builder(queryDef.getNextStageNumber()).inputs(new StageInputSpec(queryDef.getFinalStageDefinition().getStageNumber())).maxWorkerCount(this.tuningConfig.getMaxNumWorkers()).signature(finalShuffleStageDef.getSignature()).shuffleSpec(null).processor(new QueryResultStageProcessor()));
                return builder.build();
            }
            return queryDef;
        }
        if (MSQControllerTask.isExport(this.destination)) {
            ExportMSQDestination exportMSQDestination = (ExportMSQDestination)this.destination;
            ExportStorageProvider exportStorageProvider = exportMSQDestination.getExportStorageProvider();
            ResultFormat resultFormat = exportMSQDestination.getResultFormat();
            QueryDefinitionBuilder builder = QueryDefinition.builder(this.queryKitSpec.getQueryId());
            builder.addAll(queryDef);
            builder.add(StageDefinition.builder(queryDef.getNextStageNumber()).inputs(new StageInputSpec(queryDef.getFinalStageDefinition().getStageNumber())).maxWorkerCount(this.tuningConfig.getMaxNumWorkers()).signature(queryDef.getFinalStageDefinition().getSignature()).shuffleSpec(null).processor(new ExportResultsStageProcessor(this.queryKitSpec.getQueryId(), exportStorageProvider, resultFormat, this.columnMappings, this.resultsContext)));
            return builder.build();
        }
        throw new ISE("Unsupported destination [%s]", new Object[]{this.destination});
    }

    private ShuffleSpecFactory makeResultShuffleSpecFacory() {
        if (MSQControllerTask.isIngestion(this.destination)) {
            return this.destination.getShuffleSpecFactory(this.tuningConfig.getRowsPerSegment());
        }
        return this.destination.getShuffleSpecFactory(MultiStageQueryContext.getRowsPerPage(this.query.context()));
    }

    private static Query<?> propagateWindowOperatorTransformationContext(Query<?> query) {
        Boolean val = query.context().getBoolean("windowFunctionOperatorTransformation");
        if (val != null) {
            return query.withDataSource(QueryKitBasedMSQPlanner.setWindowOperatorTransformationContext(query.getDataSource(), val));
        }
        return query;
    }

    private static DataSource setWindowOperatorTransformationContext(DataSource dataSource, boolean val) {
        List children = dataSource.getChildren();
        ArrayList<DataSource> newChildren = new ArrayList<DataSource>();
        for (DataSource child : children) {
            newChildren.add(QueryKitBasedMSQPlanner.setWindowOperatorTransformationContext(child, val));
        }
        if (dataSource instanceof QueryDataSource && ((QueryDataSource)dataSource).getQuery() instanceof WindowOperatorQuery) {
            return new QueryDataSource(((QueryDataSource)dataSource).getQuery().withOverriddenContext(Map.of("windowFunctionOperatorTransformation", val)).withDataSource((DataSource)Iterables.getOnlyElement(newChildren)));
        }
        return dataSource.withChildren(newChildren);
    }
}

