/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.function.Predicate;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class CommentStripper
extends ProxyReceiver {
    private UnicodeString currentTextNode = null;
    private Predicate<NodeName> skippedElementTest = name -> false;
    private int depthOfHole = 0;

    public CommentStripper(Receiver next) {
        super(next);
    }

    public void setSkippedElementTest(Predicate<NodeName> test) {
        this.skippedElementTest = test;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            if (this.skippedElementTest.test(elemName)) {
                ++this.depthOfHole;
            } else {
                this.flush();
                this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
            }
        } else {
            ++this.depthOfHole;
        }
    }

    @Override
    public void endElement() throws XPathException {
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.flush();
            this.nextReceiver.endElement();
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.currentTextNode = this.currentTextNode == null ? chars : this.currentTextNode.concat(chars);
        }
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) {
    }

    @Override
    public void processingInstruction(String name, UnicodeString data, Location locationId, int properties) {
    }

    private void flush() throws XPathException {
        if (this.currentTextNode != null) {
            this.nextReceiver.characters(this.currentTextNode, Loc.NONE, 0);
        }
        this.currentTextNode = null;
    }
}

