/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;

public class SecureProtocolAttribute
implements ExchangeAttribute {
    public static final SecureProtocolAttribute INSTANCE = new SecureProtocolAttribute();

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        SSLSessionInfo ssl = exchange.getConnection().getSslSessionInfo();
        if (ssl == null || ssl.getSecureProtocol() == null) {
            return null;
        }
        return ssl.getSecureProtocol();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Secure Protocol", newValue);
    }

    public String toString() {
        return "%{SECURE_PROTOCOL}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Secure Protocol";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals("%{SECURE_PROTOCOL}")) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

