/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.utils.AbstractByteBufPool;
import org.apache.activemq.artemis.utils.AbstractPool;
import org.apache.activemq.artemis.utils.ByteUtil;

public final class SimpleString
implements CharSequence,
Serializable,
Comparable<SimpleString> {
    private static final SimpleString EMPTY = SimpleString.of("");
    private static final long serialVersionUID = 4204223851422244307L;
    private final byte[] data;
    private transient int hash;
    private transient String str;
    private transient String[] paths;

    public static SimpleString of(String string) {
        if (string == null) {
            return null;
        }
        return new SimpleString(string);
    }

    public static SimpleString of(String string, StringSimpleStringPool pool) {
        if (pool == null) {
            return SimpleString.of(string);
        }
        return (SimpleString)pool.getOrCreate(string);
    }

    public static SimpleString of(byte[] data) {
        return new SimpleString(data);
    }

    public static SimpleString of(char c) {
        return new SimpleString(c);
    }

    @Deprecated(forRemoval=true)
    public static SimpleString toSimpleString(String string) {
        return SimpleString.of(string);
    }

    @Deprecated(forRemoval=true)
    public static SimpleString toSimpleString(String string, StringSimpleStringPool pool) {
        return SimpleString.of(string, pool);
    }

    @Deprecated(forRemoval=true)
    public SimpleString(String string) {
        int len = string.length();
        this.data = new byte[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            byte low = (byte)(c & 0xFF);
            this.data[j++] = low;
            byte high = (byte)(c >> 8 & 0xFF);
            this.data[j++] = high;
        }
        this.str = string;
    }

    @Deprecated(forRemoval=true)
    public SimpleString(byte[] data) {
        this.data = data;
    }

    @Deprecated(forRemoval=true)
    public SimpleString(char c) {
        byte high;
        byte low;
        this.data = new byte[2];
        this.data[0] = low = (byte)(c & 0xFF);
        this.data[1] = high = (byte)(c >> 8 & 0xFF);
    }

    public boolean isBlank() {
        boolean result = true;
        for (int i = 0; i < this.length(); ++i) {
            if (Character.isWhitespace(this.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public int length() {
        return this.data.length >> 1;
    }

    @Override
    public char charAt(int pos) {
        if (pos < 0 || pos >= this.data.length >> 1) {
            throw new IndexOutOfBoundsException();
        }
        return (char)(this.data[pos <<= 1] & 0xFF | this.data[pos + 1] << 8 & 0xFF00);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subSeq(start, end);
    }

    public static SimpleString readNullableSimpleString(ByteBuf buffer) {
        byte b = buffer.readByte();
        if (b == 0) {
            return null;
        }
        return SimpleString.readSimpleString(buffer);
    }

    public static SimpleString readNullableSimpleString(ByteBuf buffer, ByteBufSimpleStringPool pool) {
        byte b = buffer.readByte();
        if (b == 0) {
            return null;
        }
        return SimpleString.readSimpleString(buffer, pool);
    }

    public static SimpleString readSimpleString(ByteBuf buffer) {
        int len = buffer.readInt();
        return SimpleString.readSimpleString(buffer, len);
    }

    public static SimpleString readSimpleString(ByteBuf buffer, ByteBufSimpleStringPool pool) {
        if (pool == null) {
            return SimpleString.readSimpleString(buffer);
        }
        return (SimpleString)pool.getOrCreate(buffer);
    }

    public static SimpleString readSimpleString(ByteBuf buffer, int length) {
        if (length > buffer.readableBytes()) {
            throw new IndexOutOfBoundsException("Error reading in simpleString, length=" + length + " is greater than readableBytes=" + buffer.readableBytes());
        }
        byte[] data = new byte[length];
        buffer.readBytes(data);
        return SimpleString.of(data);
    }

    public static void writeNullableSimpleString(ByteBuf buffer, SimpleString val) {
        if (val == null) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(1);
            SimpleString.writeSimpleString(buffer, val);
        }
    }

    public static void writeSimpleString(ByteBuf buffer, SimpleString val) {
        byte[] data = val.getData();
        buffer.writeInt(data.length);
        buffer.writeBytes(data);
    }

    public SimpleString subSeq(int start, int end) {
        int len = this.data.length >> 1;
        if (end < start || start < 0 || end > len) {
            throw new IndexOutOfBoundsException();
        }
        int newlen = end - start << 1;
        byte[] bytes = new byte[newlen];
        System.arraycopy(this.data, start << 1, bytes, 0, newlen);
        return SimpleString.of(bytes);
    }

    @Override
    public int compareTo(SimpleString o) {
        return this.toString().compareTo(o.toString());
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean startsWith(SimpleString other) {
        byte[] otherdata = other.data;
        if (otherdata.length > this.data.length) {
            return false;
        }
        for (int i = 0; i < otherdata.length; ++i) {
            if (this.data[i] == otherdata[i]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(char other) {
        return this.data.length > 0 && this.data[0] == other;
    }

    @Override
    public String toString() {
        if (this.str == null) {
            int len = this.data.length >> 1;
            char[] chars = new char[len];
            int j = 0;
            for (int i = 0; i < len; ++i) {
                int low = this.data[j++] & 0xFF;
                int high = this.data[j++] << 8 & 0xFF00;
                chars[i] = (char)(low | high);
            }
            this.str = new String(chars);
        }
        return this.str;
    }

    public String[] getPaths(char separator) {
        if (this.paths != null) {
            return this.paths;
        }
        ArrayList<String> pathsList = new ArrayList<String>();
        StringBuilder pathAccumulator = new StringBuilder();
        char[] chars = this.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == separator && (i == 0 || chars[i - 1] != '\\')) {
                pathsList.add(pathAccumulator.toString());
                pathAccumulator.delete(0, pathAccumulator.length());
                continue;
            }
            pathAccumulator.append(c);
        }
        pathsList.add(pathAccumulator.toString());
        this.paths = pathsList.toArray(new String[0]);
        return this.paths;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleString)) {
            return false;
        }
        SimpleString other = (SimpleString)obj;
        return ByteUtil.equals(this.data, other.data);
    }

    public boolean equals(ByteBuf byteBuf, int offset, int length) {
        return ByteUtil.equals(this.data, byteBuf, offset, length);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int tmphash = 0;
            for (byte element : this.data) {
                tmphash = (tmphash << 5) - tmphash + element;
            }
            this.hash = tmphash;
        }
        return this.hash;
    }

    public SimpleString[] split(char delim) {
        if (this.str != null) {
            return SimpleString.splitWithCachedString(this, delim);
        }
        return this.splitWithoutCachedString(delim);
    }

    private SimpleString[] splitWithoutCachedString(char delim) {
        ArrayList<SimpleString> all = null;
        byte low = (byte)(delim & 0xFF);
        byte high = (byte)(delim >> 8 & 0xFF);
        int lasPos = 0;
        int i = 0;
        while (i + 1 < this.data.length) {
            if (this.data[i] == low && this.data[i + 1] == high) {
                byte[] bytes = new byte[i - lasPos];
                System.arraycopy(this.data, lasPos, bytes, 0, bytes.length);
                lasPos = i + 2;
                if (all == null) {
                    all = new ArrayList<SimpleString>(2);
                }
                all.add(SimpleString.of(bytes));
            }
            i += 2;
        }
        if (all == null) {
            return new SimpleString[]{this};
        }
        byte[] bytes = new byte[this.data.length - lasPos];
        System.arraycopy(this.data, lasPos, bytes, 0, bytes.length);
        all.add(SimpleString.of(bytes));
        SimpleString[] parts = new SimpleString[all.size()];
        return all.toArray(parts);
    }

    private static SimpleString[] splitWithCachedString(SimpleString simpleString, int delim) {
        int delimIndex;
        String str = simpleString.str;
        byte[] data = simpleString.data;
        int length = str.length();
        List<SimpleString> all = null;
        int index = 0;
        while (index < length && (delimIndex = str.indexOf(delim, index)) != -1) {
            all = SimpleString.addSimpleStringPart(all, data, index, delimIndex);
            index = delimIndex + 1;
        }
        if (all == null) {
            return new SimpleString[]{simpleString};
        }
        all = SimpleString.addSimpleStringPart(all, data, index, length);
        SimpleString[] parts = new SimpleString[all.size()];
        return all.toArray(parts);
    }

    private static List<SimpleString> addSimpleStringPart(List<SimpleString> all, byte[] data, int startIndex, int endIndex) {
        SimpleString ss;
        int expectedLength = endIndex - startIndex;
        if (expectedLength == 0) {
            ss = EMPTY;
        } else {
            int ssIndex = startIndex << 1;
            int delIndex = endIndex << 1;
            byte[] bytes = Arrays.copyOfRange(data, ssIndex, delIndex);
            ss = SimpleString.of(bytes);
        }
        if (all == null) {
            all = new ArrayList<SimpleString>(3);
        }
        all.add(ss);
        return all;
    }

    public boolean contains(char c) {
        if (this.str != null) {
            return this.str.indexOf(c) != -1;
        }
        byte low = (byte)(c & 0xFF);
        byte high = (byte)(c >> 8 & 0xFF);
        int i = 0;
        while (i + 1 < this.data.length) {
            if (this.data[i] == low && this.data[i + 1] == high) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public SimpleString concat(String toAdd) {
        int len = toAdd.length();
        byte[] bytes = new byte[this.data.length + len * 2];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        for (int i = 0; i < len; ++i) {
            char c = toAdd.charAt(i);
            int offset = this.data.length + i * 2;
            bytes[offset] = (byte)(c & 0xFF);
            bytes[offset + 1] = (byte)(c >> 8 & 0xFF);
        }
        return SimpleString.of(bytes);
    }

    public SimpleString concat(SimpleString toAdd) {
        byte[] bytes = new byte[this.data.length + toAdd.getData().length];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        System.arraycopy(toAdd.getData(), 0, bytes, this.data.length, toAdd.getData().length);
        return SimpleString.of(bytes);
    }

    public SimpleString concat(char c) {
        byte[] bytes = new byte[this.data.length + 2];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        bytes[this.data.length] = (byte)(c & 0xFF);
        bytes[this.data.length + 1] = (byte)(c >> 8 & 0xFF);
        return SimpleString.of(bytes);
    }

    public int sizeof() {
        return 4 + this.data.length;
    }

    public static int sizeofString(SimpleString str) {
        return str.sizeof();
    }

    public static int sizeofNullableString(SimpleString str) {
        if (str == null) {
            return 1;
        }
        return 1 + str.sizeof();
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstPos) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.length()) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        int j = srcBegin * 2;
        int d = dstPos;
        for (int i = srcBegin; i < srcEnd; ++i) {
            int low = this.data[j++] & 0xFF;
            int high = this.data[j++] << 8 & 0xFF00;
            dst[d++] = (char)(low | high);
        }
    }

    public static final class StringSimpleStringPool
    extends AbstractPool<String, SimpleString> {
        public StringSimpleStringPool() {
        }

        public StringSimpleStringPool(int capacity) {
            super(capacity);
        }

        @Override
        protected SimpleString create(String value) {
            return SimpleString.of(value);
        }

        @Override
        protected boolean isEqual(SimpleString entry, String value) {
            if (entry == null) {
                return false;
            }
            return entry.toString().equals(value);
        }
    }

    public static final class ByteBufSimpleStringPool
    extends AbstractByteBufPool<SimpleString> {
        public static final int DEFAULT_MAX_LENGTH = 36;
        private final int maxLength;

        public ByteBufSimpleStringPool() {
            this.maxLength = 36;
        }

        public ByteBufSimpleStringPool(int capacity) {
            this(capacity, 36);
        }

        public ByteBufSimpleStringPool(int capacity, int maxCharsLength) {
            super(capacity);
            this.maxLength = maxCharsLength;
        }

        @Override
        protected boolean isEqual(SimpleString entry, ByteBuf byteBuf, int offset, int length) {
            if (entry == null) {
                return false;
            }
            return entry.equals(byteBuf, offset, length);
        }

        @Override
        protected boolean canPool(ByteBuf byteBuf, int length) {
            assert (length % 2 == 0) : "length must be a multiple of 2";
            int expectedStringLength = length >> 1;
            return expectedStringLength <= this.maxLength;
        }

        @Override
        protected SimpleString create(ByteBuf byteBuf, int length) {
            return SimpleString.readSimpleString(byteBuf, length);
        }
    }
}

