/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;

public class Match<T> {
    private static final String WILDCARD_REPLACEMENT = ".*";
    private static final String WORD_WILDCARD_REPLACEMENT_FORMAT = "[^%s]+";
    private static final String WILDCARD_CHILD_REPLACEMENT_FORMAT = "(%s.+)*";
    private static final String DOT = ".";
    private static final String DOT_REPLACEMENT = "\\.";
    private static final char DOLLAR_CHAR = '$';
    private static final String DOLLAR = String.valueOf('$');
    private static final String DOLLAR_REPLACEMENT = "\\" + DOLLAR;
    private final String match;
    private final Pattern pattern;
    private final T value;
    private final boolean literal;

    public Match(String match, T value, WildcardConfiguration wildcardConfiguration) {
        this(match, value, wildcardConfiguration, false);
    }

    public Match(String match, T value, WildcardConfiguration wildcardConfiguration, boolean literal) {
        this.match = match;
        this.value = value;
        String actMatch = match;
        if (wildcardConfiguration.getAnyWordsString().equals(match)) {
            actMatch = WILDCARD_REPLACEMENT;
        } else {
            actMatch = actMatch.replace(wildcardConfiguration.getDelimiterString() + wildcardConfiguration.getAnyWordsString(), wildcardConfiguration.getAnyWordsString());
            actMatch = actMatch.replace(DOT, DOT_REPLACEMENT);
            if (!wildcardConfiguration.contains('$')) {
                actMatch = actMatch.replace(DOLLAR, DOLLAR_REPLACEMENT);
            }
            actMatch = actMatch.replace(wildcardConfiguration.getSingleWordString(), String.format(WORD_WILDCARD_REPLACEMENT_FORMAT, Pattern.quote(wildcardConfiguration.getDelimiterString())));
            actMatch = actMatch.replace(wildcardConfiguration.getAnyWordsString(), String.format(WILDCARD_CHILD_REPLACEMENT_FORMAT, Pattern.quote(wildcardConfiguration.getDelimiterString())));
        }
        this.pattern = Pattern.compile(actMatch + DOLLAR);
        this.literal = literal;
    }

    public final String getMatch() {
        return this.match;
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public final T getValue() {
        return this.value;
    }

    public final boolean isLiteral() {
        return this.literal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Match)) {
            return false;
        }
        Match other = (Match)obj;
        return Objects.equals(this.match, other.match);
    }

    public int hashCode() {
        return Objects.hashCode(this.match);
    }

    public static void verify(String match, WildcardConfiguration wildcardConfiguration) throws IllegalArgumentException {
        if (match == null) {
            throw ActiveMQMessageBundle.BUNDLE.nullMatch();
        }
        String anyWords = wildcardConfiguration.getAnyWordsString();
        if (match.contains(anyWords) && match.indexOf(anyWords) < match.length() - 1) {
            throw ActiveMQMessageBundle.BUNDLE.invalidMatch();
        }
    }

    public String toString() {
        return this.value.toString();
    }
}

