/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public abstract class AbstractContentEncryptionAlgorithm
extends AbstractContentEncryptionCipherProperties
implements ContentEncryptionProvider {
    private static final int DEFAULT_IV_SIZE = 128;
    private byte[] cek;
    private byte[] iv;
    private AtomicInteger providedIvUsageCount;
    private boolean generateCekOnce;

    protected AbstractContentEncryptionAlgorithm(ContentAlgorithm algo, boolean generateCekOnce) {
        super(algo);
        this.generateCekOnce = generateCekOnce;
    }

    protected AbstractContentEncryptionAlgorithm(byte[] cek, byte[] iv, ContentAlgorithm algo) {
        super(algo);
        this.cek = cek;
        this.iv = iv;
        if (iv != null && iv.length > 0) {
            this.providedIvUsageCount = new AtomicInteger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getContentEncryptionKey(JweHeaders headers) {
        byte[] theCek;
        AbstractContentEncryptionAlgorithm abstractContentEncryptionAlgorithm = this;
        synchronized (abstractContentEncryptionAlgorithm) {
            if (this.cek == null) {
                String algoJava = this.getAlgorithm().getJavaName();
                SecretKey secretKey = CryptoUtils.getSecretKey((String)AlgorithmUtils.stripAlgoProperties(algoJava), (int)this.getContentEncryptionKeySize(headers));
                theCek = secretKey.getEncoded();
                if (this.generateCekOnce) {
                    this.cek = theCek;
                }
                try {
                    secretKey.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {}
            } else {
                theCek = this.cek;
            }
        }
        return theCek;
    }

    @Override
    public byte[] getInitVector() {
        if (this.iv == null) {
            return CryptoUtils.generateSecureRandomBytes((int)(this.getIvSize() / 8));
        }
        if (this.iv.length > 0 && this.providedIvUsageCount.addAndGet(1) > 1) {
            LOG.warning("Custom IV is recommended to be used once");
            throw new JweException(JweException.Error.CUSTOM_IV_REUSED);
        }
        return this.iv;
    }

    protected int getContentEncryptionKeySize(JweHeaders headers) {
        return this.getAlgorithm().getKeySizeBits();
    }

    protected int getIvSize() {
        return 128;
    }
}

