/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.ThreadLocalByteBufferHolder;
import org.jctools.queues.MpmcArrayQueue;

public class SimpleCachedBufferPool {
    private final ThreadLocalByteBufferHolder bufferHolder;
    private final Queue<ByteBuffer> bufferPool;
    private AtomicInteger usedBuffers = new AtomicInteger(0);
    private final int maxBufferPoolSize;
    private final int bufferSize;
    private final BufferType preferredReusableBufferType;

    public SimpleCachedBufferPool(int maxBufferPoolSize, int bufferSize, BufferType preferredReusableBufferType) {
        this.bufferPool = new MpmcArrayQueue(maxBufferPoolSize);
        this.maxBufferPoolSize = maxBufferPoolSize;
        this.bufferSize = bufferSize;
        this.preferredReusableBufferType = preferredReusableBufferType;
        this.bufferHolder = new ThreadLocalByteBufferHolder(preferredReusableBufferType);
    }

    public ByteBuffer createBuffer() {
        this.usedBuffers.incrementAndGet();
        ByteBuffer buf = this.bufferPool.poll();
        if (buf != null) {
            buf.clear();
            return buf;
        }
        return this.preferredReusableBufferType.allocate(this.bufferSize);
    }

    public ByteBuffer getThreadLocalReusableBuffer(int size) {
        return this.bufferHolder.getBuffer(size);
    }

    public void releaseBuffer(ByteBuffer buffer) {
        assert (buffer != null);
        assert (this.preferredReusableBufferType == BufferType.typeOf(buffer));
        this.usedBuffers.decrementAndGet();
        if (!this.bufferPool.offer(buffer)) {
            FileUtils.clean(buffer);
        }
    }

    public void emptyBufferPool() {
        ByteBuffer buffer = this.bufferPool.poll();
        while (buffer != null) {
            FileUtils.clean(buffer);
            buffer = this.bufferPool.poll();
        }
    }

    public boolean atLimit() {
        return this.usedBuffers.get() >= this.maxBufferPoolSize;
    }

    public String toString() {
        return "SimpleBufferPool:" + " usedBuffers:" + this.usedBuffers.get() + ", maxBufferPoolSize:" + this.maxBufferPoolSize + ", bufferSize:" + this.bufferSize;
    }
}

