/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.bookkeeper.bookie.BookieFileChannel;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.apache.bookkeeper.bookie.DefaultFileChannelProvider;
import org.apache.bookkeeper.bookie.FileChannelProvider;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.util.PageCacheUtil;
import org.apache.bookkeeper.util.ZeroBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JournalChannel
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JournalChannel.class);
    static final long MB = 0x100000L;
    final BookieFileChannel channel;
    final int fd;
    final FileChannel fc;
    final int formatVersion;
    BufferedChannel bc;
    long nextPrealloc = 0L;
    final byte[] magicWord = "BKLG".getBytes(StandardCharsets.UTF_8);
    static final int SECTOR_SIZE = 512;
    private static final int START_OF_FILE = -12345;
    private static final long cacheDropLagBytes = 0x800000L;
    static final int V1 = 1;
    static final int V2 = 2;
    static final int V3 = 3;
    static final int V4 = 4;
    static final int V5 = 5;
    public static final int V6 = 6;
    static final int HEADER_SIZE = 512;
    static final int VERSION_HEADER_SIZE = 8;
    static final int MIN_COMPAT_JOURNAL_FORMAT_VERSION = 1;
    static final int CURRENT_JOURNAL_FORMAT_VERSION = 6;
    private final long preAllocSize;
    private final int journalAlignSize;
    private final boolean fRemoveFromPageCache;
    public final ByteBuffer zeros;
    private long lastDropPosition = 0L;
    final ServerConfiguration configuration;

    JournalChannel(File journalDirectory, long logId) throws IOException {
        this(journalDirectory, logId, 0x400000L, 65536, -12345L, new ServerConfiguration(), new DefaultFileChannelProvider());
    }

    JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize, ServerConfiguration conf, FileChannelProvider provider) throws IOException {
        this(journalDirectory, logId, preAllocSize, writeBufferSize, -12345L, conf, provider);
    }

    JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize, long position, ServerConfiguration conf, FileChannelProvider provider) throws IOException {
        this(journalDirectory, logId, preAllocSize, writeBufferSize, 512, position, false, 5, Journal.BufferedChannelBuilder.DEFAULT_BCBUILDER, conf, provider, null);
    }

    JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize, int journalAlignSize, boolean fRemoveFromPageCache, int formatVersionToWrite, ServerConfiguration conf, FileChannelProvider provider) throws IOException {
        this(journalDirectory, logId, preAllocSize, writeBufferSize, journalAlignSize, fRemoveFromPageCache, formatVersionToWrite, Journal.BufferedChannelBuilder.DEFAULT_BCBUILDER, conf, provider, null);
    }

    JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize, int journalAlignSize, boolean fRemoveFromPageCache, int formatVersionToWrite, Journal.BufferedChannelBuilder bcBuilder, ServerConfiguration conf, FileChannelProvider provider, Long toReplaceLogId) throws IOException {
        this(journalDirectory, logId, preAllocSize, writeBufferSize, journalAlignSize, -12345L, fRemoveFromPageCache, formatVersionToWrite, bcBuilder, conf, provider, toReplaceLogId);
    }

    private JournalChannel(File journalDirectory, long logId, long preAllocSize, int writeBufferSize, int journalAlignSize, long position, boolean fRemoveFromPageCache, int formatVersionToWrite, Journal.BufferedChannelBuilder bcBuilder, ServerConfiguration conf, FileChannelProvider provider, Long toReplaceLogId) throws IOException {
        File toReplaceFile;
        this.journalAlignSize = journalAlignSize;
        this.zeros = ByteBuffer.allocate(journalAlignSize);
        this.preAllocSize = preAllocSize - preAllocSize % (long)journalAlignSize;
        this.fRemoveFromPageCache = fRemoveFromPageCache;
        this.configuration = conf;
        boolean reuseFile = false;
        File fn = new File(journalDirectory, Long.toHexString(logId) + ".txn");
        if (toReplaceLogId != null && logId != toReplaceLogId && provider.supportReuseFile() && (toReplaceFile = new File(journalDirectory, Long.toHexString(toReplaceLogId) + ".txn")).exists()) {
            JournalChannel.renameJournalFile(toReplaceFile, fn);
            provider.notifyRename(toReplaceFile, fn);
            reuseFile = true;
        }
        this.channel = provider.open(fn, this.configuration);
        if (formatVersionToWrite < 4) {
            throw new IOException("Invalid journal format to write : version = " + formatVersionToWrite);
        }
        LOG.info("Opening journal {}", (Object)fn);
        if (!this.channel.fileExists(fn)) {
            if (!fn.createNewFile()) {
                LOG.error("Journal file {}, that shouldn't exist, already exists.  is there another bookie process running?", (Object)fn);
                throw new IOException("File " + fn + " suddenly appeared, is another bookie process running?");
            }
            this.fc = this.channel.getFileChannel();
            this.formatVersion = formatVersionToWrite;
            this.writeHeader(bcBuilder, writeBufferSize);
        } else if (reuseFile) {
            this.fc = this.channel.getFileChannel();
            this.formatVersion = formatVersionToWrite;
            this.writeHeader(bcBuilder, writeBufferSize);
        } else {
            this.fc = this.channel.getFileChannel();
            ByteBuffer bb = ByteBuffer.allocate(8);
            int c = this.fc.read(bb);
            bb.flip();
            if (c == 8) {
                byte[] first4 = new byte[4];
                bb.get(first4);
                this.formatVersion = Arrays.equals(first4, this.magicWord) ? bb.getInt() : 1;
            } else {
                this.formatVersion = 1;
            }
            if (this.formatVersion < 1 || this.formatVersion > 6) {
                String err = String.format("Invalid journal version, unable to read. Expected between (%d) and (%d), got (%d)", 1, 6, this.formatVersion);
                LOG.error(err);
                throw new IOException(err);
            }
            try {
                if (position == -12345L) {
                    if (this.formatVersion >= 5) {
                        this.fc.position(512L);
                    } else if (this.formatVersion >= 2) {
                        this.fc.position(8L);
                    } else {
                        this.fc.position(0L);
                    }
                } else {
                    this.fc.position(position);
                }
            }
            catch (IOException e) {
                LOG.error("Bookie journal file can seek to position :", (Throwable)e);
                throw e;
            }
        }
        this.fd = fRemoveFromPageCache ? PageCacheUtil.getSysFileDescriptor(this.channel.getFD()) : -1;
    }

    private void writeHeader(Journal.BufferedChannelBuilder bcBuilder, int writeBufferSize) throws IOException {
        int headerSize = 4 == this.formatVersion ? 8 : 512;
        ByteBuffer bb = ByteBuffer.allocate(headerSize);
        ZeroBuffer.put(bb);
        bb.clear();
        bb.put(this.magicWord);
        bb.putInt(this.formatVersion);
        bb.clear();
        this.fc.write(bb);
        this.bc = bcBuilder.create(this.fc, writeBufferSize);
        this.forceWrite(true);
        this.nextPrealloc = this.preAllocSize;
        this.fc.write(this.zeros, this.nextPrealloc - (long)this.journalAlignSize);
    }

    public static void renameJournalFile(File source, File target) throws IOException {
        if (source == null || target == null || !source.renameTo(target)) {
            LOG.error("Failed to rename file {} to {}", (Object)source, (Object)target);
            throw new IOException("Failed to rename file " + source + " to " + target);
        }
    }

    int getFormatVersion() {
        return this.formatVersion;
    }

    BufferedChannel getBufferedChannel() throws IOException {
        if (this.bc == null) {
            throw new IOException("Read only journal channel");
        }
        return this.bc;
    }

    void preAllocIfNeeded(long size) throws IOException {
        if (this.bc.position() + size > this.nextPrealloc) {
            this.nextPrealloc += this.preAllocSize;
            this.zeros.clear();
            this.fc.write(this.zeros, this.nextPrealloc - (long)this.journalAlignSize);
        }
    }

    int read(ByteBuffer dst) throws IOException {
        return this.fc.read(dst);
    }

    @Override
    public void close() throws IOException {
        if (this.bc != null) {
            this.bc.close();
        } else if (this.fc != null) {
            this.fc.close();
        }
    }

    public void forceWrite(boolean forceMetadata) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Journal ForceWrite");
        }
        long newForceWritePosition = this.bc.forceWrite(forceMetadata);
        if (this.fRemoveFromPageCache) {
            long newDropPos = newForceWritePosition - 0x800000L;
            if (this.lastDropPosition < newDropPos) {
                PageCacheUtil.bestEffortRemoveFromPageCache(this.fd, this.lastDropPosition, newDropPos - this.lastDropPosition);
            }
            this.lastDropPosition = newDropPos;
        }
    }
}

