/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerStats;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ServerStatsTest
extends ZKTestCase {
    private ServerStats.Provider providerMock;

    @BeforeEach
    public void setUp() {
        this.providerMock = (ServerStats.Provider)Mockito.mock(ServerStats.Provider.class);
    }

    @Test
    public void testPacketsMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        int incrementCount = 20;
        for (int i = 0; i < incrementCount; ++i) {
            serverStats.incrementPacketsSent();
            serverStats.incrementPacketsReceived();
            serverStats.incrementPacketsReceived();
        }
        Assertions.assertEquals((long)incrementCount, (long)serverStats.getPacketsSent());
        Assertions.assertEquals((long)(incrementCount * 2), (long)serverStats.getPacketsReceived());
        serverStats.resetRequestCounters();
        this.assertAllPacketsZero(serverStats);
    }

    @Test
    public void testLatencyMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        Request fakeRequest = new Request(0L, 0, 0, null, null, 0L);
        serverStats.updateLatency(fakeRequest, fakeRequest.createTime + 1000L);
        serverStats.updateLatency(fakeRequest, fakeRequest.createTime + 2000L);
        MatcherAssert.assertThat((String)"Max latency check", (Object)2000L, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(serverStats.getMaxLatency())));
        MatcherAssert.assertThat((String)"Min latency check", (Object)1000L, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(serverStats.getMinLatency())));
        Assertions.assertEquals((double)1500.0, (double)serverStats.getAvgLatency(), (double)200.0);
        serverStats.resetLatency();
        this.assertAllLatencyZero(serverStats);
    }

    @Test
    public void testFsyncThresholdExceedMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        int incrementCount = 30;
        for (int i = 0; i < incrementCount; ++i) {
            serverStats.incrementFsyncThresholdExceedCount();
        }
        Assertions.assertEquals((long)incrementCount, (long)serverStats.getFsyncThresholdExceedCount());
        serverStats.resetFsyncThresholdExceedCount();
        this.assertFsyncThresholdExceedCountZero(serverStats);
    }

    @Test
    public void testReset() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        this.assertAllPacketsZero(serverStats);
        this.assertAllLatencyZero(serverStats);
        Request fakeRequest = new Request(0L, 0, 0, null, null, 0L);
        serverStats.incrementPacketsSent();
        serverStats.incrementPacketsReceived();
        serverStats.updateLatency(fakeRequest, fakeRequest.createTime + 1000L);
        serverStats.reset();
        this.assertAllPacketsZero(serverStats);
        this.assertAllLatencyZero(serverStats);
    }

    private void assertAllPacketsZero(ServerStats serverStats) {
        Assertions.assertEquals((long)0L, (long)serverStats.getPacketsSent());
        Assertions.assertEquals((long)0L, (long)serverStats.getPacketsReceived());
    }

    private void assertAllLatencyZero(ServerStats serverStats) {
        Assertions.assertEquals((long)0L, (long)serverStats.getMaxLatency());
        Assertions.assertEquals((long)0L, (long)serverStats.getMinLatency());
        Assertions.assertEquals((double)0.0, (double)serverStats.getAvgLatency(), (double)1.0E-5);
    }

    private void assertFsyncThresholdExceedCountZero(ServerStats serverStats) {
        Assertions.assertEquals((long)0L, (long)serverStats.getFsyncThresholdExceedCount());
    }
}

