# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE OVERWRITTEN!
#
# IF YOU WANT TO MODIFY THIS FILE, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `dev/breeze/src/airflow_breeze/templates` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-docker",
        "name": "Docker",
        "description": "`Docker <https://www.docker.com/>`__\n",
        "integrations": [
            {
                "integration-name": "Docker",
                "external-doc-url": "https://docs.docker.com/",
                "logo": "/docs/integration-logos/Docker.png",
                "tags": ["software"],
            },
            {
                "integration-name": "Docker Swarm",
                "external-doc-url": "https://docs.docker.com/engine/swarm/",
                "logo": "/docs/integration-logos/Docker-Swarm.png",
                "tags": ["software"],
            },
        ],
        "operators": [
            {"integration-name": "Docker", "python-modules": ["airflow.providers.docker.operators.docker"]},
            {
                "integration-name": "Docker Swarm",
                "python-modules": ["airflow.providers.docker.operators.docker_swarm"],
            },
        ],
        "hooks": [
            {"integration-name": "Docker", "python-modules": ["airflow.providers.docker.hooks.docker"]}
        ],
        "connection-types": [
            {
                "hook-class-name": "airflow.providers.docker.hooks.docker.DockerHook",
                "connection-type": "docker",
                "conn-fields": {
                    "reauth": {
                        "label": "Reauthenticate",
                        "schema": {"type": ["boolean", "null"]},
                        "description": "Whether or not to refresh existing authentication on the Docker server.",
                    },
                    "email": {"label": "Email", "schema": {"type": ["string", "null"]}},
                },
                "ui-field-behaviour": {
                    "hidden-fields": ["schema"],
                    "relabeling": {"host": "Registry URL", "login": "Username"},
                    "placeholders": {"extra": '{"reauth": false, "email": "Jane.Doe@example.org"}'},
                },
            }
        ],
        "task-decorators": [
            {"class-name": "airflow.providers.docker.decorators.docker.docker_task", "name": "docker"}
        ],
    }
