/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQClientProtocolManager;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.apache.activemq.artemis.core.protocol.hornetq.client.HornetQClientSessionContext;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;

public class HornetQClientProtocolManager
extends ActiveMQClientProtocolManager {
    private static final int VERSION_PLAYED = 123;

    protected void sendHandshake(Connection transportConnection) {
    }

    protected SessionContext newSessionContext(String name, int confirmationWindowSize, Channel sessionChannel, CreateSessionResponseMessage response) {
        return new HornetQClientSessionContext(name, (RemotingConnection)this.connection, sessionChannel, response.getServerVersion(), confirmationWindowSize);
    }

    protected Packet newCreateSessionPacket(int clientVersion, String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int minLargeMessageSize, int confirmationWindowSize, long sessionChannelID, String clientID) {
        return super.newCreateSessionPacket(123, name, username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, minLargeMessageSize, confirmationWindowSize, sessionChannelID, clientID);
    }

    public void sendSubscribeTopology(boolean isServer) {
        this.getChannel0().send((Packet)new SubscribeClusterTopologyUpdatesMessageV2(isServer, 123));
    }

    public boolean checkForFailover(String nodeID) throws ActiveMQException {
        return true;
    }

    protected ClusterTopologyChangeMessage updateTransportConfiguration(ClusterTopologyChangeMessage topMessage) {
        this.updateTransportConfiguration((TransportConfiguration)topMessage.getPair().getA());
        this.updateTransportConfiguration((TransportConfiguration)topMessage.getPair().getB());
        return super.updateTransportConfiguration(topMessage);
    }

    private void updateTransportConfiguration(TransportConfiguration connector) {
        String factoryClassName;
        if (connector != null && "org.hornetq.core.remoting.impl.netty.NettyConnectorFactory".equals(factoryClassName = connector.getFactoryClassName())) {
            connector.setFactoryClassName(NettyConnectorFactory.class.getName());
        }
    }
}

