/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.util.ClassUtil;

public class JettyDetector
extends AbstractServerDetector {
    @Override
    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        Class serverClass = ClassUtil.classForName("org.mortbay.jetty.Server", false, new ClassLoader[0]);
        if (serverClass != null) {
            return new ServerHandle("Mortbay", "jetty", this.getVersion(serverClass), null);
        }
        serverClass = ClassUtil.classForName("org.eclipse.jetty.server.Server", false, new ClassLoader[0]);
        if (serverClass != null) {
            return new ServerHandle("Eclipse", "jetty", this.getVersion(serverClass), null);
        }
        return null;
    }

    private String getVersion(Class serverClass) {
        try {
            Method method = serverClass.getMethod("getVersion", new Class[0]);
            if (Modifier.isStatic(method.getModifiers())) {
                return (String)method.invoke(null, new Object[0]);
            }
            Constructor ctr = serverClass.getConstructor(new Class[0]);
            Object server = ctr.newInstance(new Object[0]);
            return (String)method.invoke(server, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }
}

